/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import lombok.NonNull;
import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;

public abstract class PatchOperation {
    @NonNull
    protected final String op;
    @NonNull
    protected final SpelPath path;
    protected final Object value;

    public PatchOperation(String op, SpelPath path) {
        this(op, path, null);
    }

    protected Object evaluateValueFromTarget(Object targetObject, Class<?> entityType) {
        return this.evaluate(this.path.bindTo(entityType).getType(targetObject));
    }

    protected final Object evaluate(Class<?> type) {
        return this.value instanceof LateObjectEvaluator ? ((LateObjectEvaluator)this.value).evaluate(type) : this.value;
    }

    abstract void perform(Object var1, Class<?> var2);

    public PatchOperation(@NonNull String op, @NonNull SpelPath path, Object value) {
        if (op == null) {
            throw new IllegalArgumentException("op is marked @NonNull but is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is marked @NonNull but is null");
        }
        this.op = op;
        this.path = path;
        this.value = value;
    }
}

