/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DeleteAggregateChange;
import org.springframework.data.relational.core.conversion.DeleteBatchingAggregateChange;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.conversion.RootAggregateChange;
import org.springframework.data.relational.core.conversion.SaveBatchingAggregateChange;
import org.springframework.util.Assert;

public interface BatchingAggregateChange<T, C extends MutableAggregateChange<T>>
extends AggregateChange<T> {
    public void add(C var1);

    public static <T> BatchingAggregateChange<T, RootAggregateChange<T>> forSave(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new SaveBatchingAggregateChange<T>(entityClass);
    }

    public static <T> BatchingAggregateChange<T, DeleteAggregateChange<T>> forDelete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new DeleteBatchingAggregateChange<T>(entityClass);
    }
}

