/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.ByteArrayOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.DateOutput;
import io.lettuce.core.output.DoubleOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.KeyValueOutput;
import io.lettuce.core.output.MapOutput;
import io.lettuce.core.output.MultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.output.ValueSetOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceListCommands;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.connection.lettuce.LettuceScriptingCommands;
import org.springframework.data.redis.connection.lettuce.LettuceSentinelConnection;
import org.springframework.data.redis.connection.lettuce.LettuceServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceStreamCommands;
import org.springframework.data.redis.connection.lettuce.LettuceStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceSubscription;
import org.springframework.data.redis.connection.lettuce.LettuceZSetCommands;
import org.springframework.data.redis.connection.lettuce.StandaloneConnectionProvider;
import org.springframework.data.redis.core.RedisCommand;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class LettuceConnection
extends AbstractRedisConnection {
    static final RedisCodec<byte[], byte[]> CODEC = ByteArrayCodec.INSTANCE;
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    private static final TypeHints typeHints = new TypeHints();
    private final int defaultDbIndex;
    private int dbIndex;
    private final LettuceConnectionProvider connectionProvider;
    @Nullable
    private final StatefulConnection<byte[], byte[]> asyncSharedConn;
    @Nullable
    private StatefulConnection<byte[], byte[]> asyncDedicatedConn;
    private final long timeout;
    private boolean isClosed = false;
    private boolean isMulti = false;
    private boolean isPipelined = false;
    @Nullable
    private List<LettuceResult> ppline;
    @Nullable
    private PipeliningFlushState flushState;
    private final Queue<FutureResult<?>> txResults = new LinkedList();
    @Nullable
    private volatile LettuceSubscription subscription;
    private boolean convertPipelineAndTxResults = true;
    private PipeliningFlushPolicy pipeliningFlushPolicy = PipeliningFlushPolicy.flushEachCommand();

    LettuceResult newLettuceResult(Future<?> resultHolder) {
        return this.newLettuceResult(resultHolder, val -> val);
    }

    <T, R> LettuceResult<T, R> newLettuceResult(Future<T> resultHolder, Converter<T, R> converter) {
        return LettuceResult.LettuceResultBuilder.forResponse(resultHolder).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).build();
    }

    <T, R> LettuceResult<T, R> newLettuceResult(Future<T> resultHolder, Converter<T, R> converter, Supplier<R> defaultValue) {
        return LettuceResult.LettuceResultBuilder.forResponse(resultHolder).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).defaultNullTo(defaultValue).build();
    }

    <T, R> LettuceResult<T, R> newLettuceStatusResult(Future<T> resultHolder) {
        return LettuceResult.LettuceResultBuilder.forResponse(resultHolder).buildStatusResult();
    }

    public LettuceConnection(long timeout, RedisClient client) {
        this(null, timeout, client, null);
    }

    @Deprecated
    public LettuceConnection(long timeout, RedisClient client, LettucePool pool) {
        this(null, timeout, client, pool);
    }

    public LettuceConnection(@Nullable StatefulRedisConnection<byte[], byte[]> sharedConnection, long timeout, RedisClient client) {
        this(sharedConnection, timeout, client, null);
    }

    @Deprecated
    public LettuceConnection(@Nullable StatefulRedisConnection<byte[], byte[]> sharedConnection, long timeout, RedisClient client, @Nullable LettucePool pool) {
        this(sharedConnection, timeout, (AbstractRedisClient)client, pool, 0);
    }

    @Deprecated
    public LettuceConnection(@Nullable StatefulRedisConnection<byte[], byte[]> sharedConnection, long timeout, @Nullable AbstractRedisClient client, @Nullable LettucePool pool, int defaultDbIndex) {
        this.connectionProvider = pool != null ? new LettucePoolConnectionProvider(pool) : new StandaloneConnectionProvider((RedisClient)client, CODEC);
        this.asyncSharedConn = sharedConnection;
        this.timeout = timeout;
        this.dbIndex = this.defaultDbIndex = defaultDbIndex;
    }

    public LettuceConnection(@Nullable StatefulRedisConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, long timeout, int defaultDbIndex) {
        this((StatefulConnection<byte[], byte[]>)sharedConnection, connectionProvider, timeout, defaultDbIndex);
    }

    LettuceConnection(@Nullable StatefulConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, long timeout, int defaultDbIndex) {
        Assert.notNull((Object)connectionProvider, (String)"LettuceConnectionProvider must not be null.");
        this.asyncSharedConn = sharedConnection;
        this.connectionProvider = connectionProvider;
        this.timeout = timeout;
        this.dbIndex = this.defaultDbIndex = defaultDbIndex;
    }

    protected DataAccessException convertLettuceAccessException(Exception ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return new LettuceGeoCommands(this);
    }

    @Override
    public RedisHashCommands hashCommands() {
        return new LettuceHashCommands(this);
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return new LettuceHyperLogLogCommands(this);
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return new LettuceKeyCommands(this);
    }

    @Override
    public RedisListCommands listCommands() {
        return new LettuceListCommands(this);
    }

    @Override
    public RedisSetCommands setCommands() {
        return new LettuceSetCommands(this);
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return new LettuceScriptingCommands(this);
    }

    @Override
    public RedisStreamCommands streamCommands() {
        return new LettuceStreamCommands(this);
    }

    @Override
    public RedisStringCommands stringCommands() {
        return new LettuceStringCommands(this);
    }

    @Override
    public RedisServerCommands serverCommands() {
        return new LettuceServerCommands(this);
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return new LettuceZSetCommands(this);
    }

    @Nullable
    private Object await(RedisFuture<?> cmd) {
        if (this.isMulti) {
            return null;
        }
        return LettuceFutures.awaitOrCancel(cmd, (long)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        return this.execute(command, (CommandOutput)null, args);
    }

    @Nullable
    public Object execute(String command, @Nullable CommandOutput commandOutputTypeHint, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            String name = command.trim().toUpperCase();
            CommandType commandType = CommandType.valueOf((String)name);
            this.validateCommandIfRunningInTransactionMode(commandType, args);
            CommandArgs cmdArg = new CommandArgs(CODEC);
            if (!ObjectUtils.isEmpty((Object[])args)) {
                cmdArg.addKeys((Object[])args);
            }
            RedisClusterAsyncCommands<byte[], byte[]> connectionImpl = this.getAsyncConnection();
            CommandOutput expectedOutput = commandOutputTypeHint != null ? commandOutputTypeHint : typeHints.getTypeHint(commandType);
            Command cmd = new Command((ProtocolKeyword)commandType, expectedOutput, cmdArg);
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceResult((Future<?>)connectionImpl.dispatch(cmd.getType(), cmd.getOutput(), cmd.getArgs())));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newLettuceResult((Future<?>)connectionImpl.dispatch(cmd.getType(), cmd.getOutput(), cmd.getArgs())));
                return null;
            }
            return this.await(connectionImpl.dispatch(cmd.getType(), cmd.getOutput(), cmd.getArgs()));
        }
        catch (RedisException ex) {
            throw this.convertLettuceAccessException((Exception)((Object)ex));
        }
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.asyncDedicatedConn != null) {
            try {
                if (this.customizedDatabaseIndex()) {
                    this.potentiallySelectDatabase(this.defaultDbIndex);
                }
                this.connectionProvider.release(this.asyncDedicatedConn);
            }
            catch (RuntimeException ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        if (this.subscription != null) {
            if (this.subscription.isAlive()) {
                this.subscription.doClose();
            }
            this.subscription = null;
        }
        this.dbIndex = this.defaultDbIndex;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed && !this.isSubscribed();
    }

    public RedisClusterAsyncCommands<byte[], byte[]> getNativeConnection() {
        LettuceSubscription subscription = this.subscription;
        return subscription != null ? subscription.getNativeConnection().async() : this.getAsyncConnection();
    }

    @Override
    public boolean isQueueing() {
        return this.isMulti;
    }

    @Override
    public boolean isPipelined() {
        return this.isPipelined;
    }

    @Override
    public void openPipeline() {
        if (!this.isPipelined) {
            this.isPipelined = true;
            this.ppline = new ArrayList<LettuceResult>();
            this.flushState = this.pipeliningFlushPolicy.newPipeline();
            this.flushState.onOpen(this.getOrCreateDedicatedConnection());
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (!this.isPipelined) {
            return Collections.emptyList();
        }
        this.flushState.onClose(this.getOrCreateDedicatedConnection());
        this.flushState = null;
        this.isPipelined = false;
        ArrayList futures = new ArrayList(this.ppline.size());
        for (LettuceResult result : this.ppline) {
            futures.add(result.getResultHolder());
        }
        try {
            boolean done = LettuceFutures.awaitAll((long)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS, (Future[])((Future[])futures.toArray(new RedisFuture[futures.size()])));
            ArrayList<Object> results = new ArrayList<Object>(futures.size());
            DataAccessException problem = null;
            if (done) {
                for (LettuceResult result : this.ppline) {
                    if (((io.lettuce.core.protocol.RedisCommand)result.getResultHolder()).getOutput().hasError()) {
                        InvalidDataAccessApiUsageException err = new InvalidDataAccessApiUsageException(((io.lettuce.core.protocol.RedisCommand)result.getResultHolder()).getOutput().getError());
                        if (problem == null) {
                            problem = err;
                        }
                        results.add(err);
                        continue;
                    }
                    if (result.isStatus()) continue;
                    try {
                        results.add(result.conversionRequired() ? result.convert(result.get()) : result.get());
                    }
                    catch (DataAccessException e) {
                        if (problem == null) {
                            problem = e;
                        }
                        results.add((Object)e);
                    }
                }
            }
            this.ppline.clear();
            if (problem != null) {
                throw new RedisPipelineException((Exception)((Object)problem), (List<Object>)results);
            }
            if (done) {
                return results;
            }
            throw new RedisPipelineException((Exception)new QueryTimeoutException("Redis command timed out"));
        }
        catch (Exception e) {
            throw new RedisPipelineException(e);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceResult((Future<?>)this.getAsyncConnection().echo((Object)message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newLettuceResult((Future<?>)this.getAsyncConnection().echo((Object)message)));
                return null;
            }
            return (byte[])this.getConnection().echo((Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceResult((Future<?>)this.getAsyncConnection().ping()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newLettuceResult((Future<?>)this.getAsyncConnection().ping()));
                return null;
            }
            return this.getConnection().ping();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void discard() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceStatusResult((Future)this.getAsyncDedicatedRedisCommands().discard()));
                return;
            }
            this.getDedicatedRedisCommands().discard();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
        finally {
            this.txResults.clear();
        }
    }

    @Override
    public List<Object> exec() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                RedisFuture exec = this.getAsyncDedicatedRedisCommands().exec();
                LettuceTransactionResultConverter resultConverter = new LettuceTransactionResultConverter(new LinkedList(this.txResults), LettuceConverters.exceptionConverter());
                this.pipeline(this.newLettuceResult((Future)exec, (Converter)source -> resultConverter.convert((List)LettuceConverters.transactionResultUnwrapper().convert(source))));
                List<Object> list = null;
                return list;
            }
            TransactionResult transactionResult = this.getDedicatedRedisCommands().exec();
            List<Object> results = (List<Object>)LettuceConverters.transactionResultUnwrapper().convert((Object)transactionResult);
            List<Object> list = this.convertPipelineAndTxResults ? new LettuceTransactionResultConverter(this.txResults, LettuceConverters.exceptionConverter()).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
        finally {
            this.txResults.clear();
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.isMulti = true;
        try {
            if (this.isPipelined()) {
                this.getAsyncDedicatedRedisCommands().multi();
                return;
            }
            this.getDedicatedRedisCommands().multi();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        if (this.asyncSharedConn != null) {
            throw new UnsupportedOperationException("Selecting a new database not supported due to shared connection. Use separate ConnectionFactorys to work with multiple databases");
        }
        try {
            this.dbIndex = dbIndex;
            if (this.isPipelined()) {
                this.pipeline(new LettuceResult.LettuceStatusResult(this.getAsyncConnection().dispatch((ProtocolKeyword)CommandType.SELECT, (CommandOutput)new StatusOutput((RedisCodec)ByteArrayCodec.INSTANCE), new CommandArgs((RedisCodec)ByteArrayCodec.INSTANCE).add((long)dbIndex))));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.newLettuceStatusResult((Future)this.getAsyncConnection().dispatch((ProtocolKeyword)CommandType.SELECT, (CommandOutput)new StatusOutput((RedisCodec)ByteArrayCodec.INSTANCE), new CommandArgs((RedisCodec)ByteArrayCodec.INSTANCE).add((long)dbIndex))));
                return;
            }
            ((RedisCommands)this.getConnection()).select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceStatusResult((Future)this.getAsyncDedicatedRedisCommands().unwatch()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.newLettuceStatusResult((Future)this.getAsyncDedicatedRedisCommands().unwatch()));
                return;
            }
            this.getDedicatedRedisCommands().unwatch();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceStatusResult((Future)this.getAsyncDedicatedRedisCommands().watch((Object[])keys)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(new LettuceResult.LettuceStatusResult(this.getAsyncDedicatedRedisCommands().watch((Object[])keys)));
                return;
            }
            this.getDedicatedRedisCommands().watch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newLettuceResult((Future<?>)this.getAsyncConnection().publish((Object)channel, (Object)message)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.newLettuceResult((Future<?>)this.getAsyncConnection().publish((Object)channel, (Object)message)));
                return null;
            }
            return this.getConnection().publish((Object)channel, (Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("Transaction/Pipelining is not supported for Pub/Sub subscriptions!");
        }
        try {
            this.subscription = this.initSubscription(listener);
            this.subscription.pSubscribe(patterns);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("Transaction/Pipelining is not supported for Pub/Sub subscriptions!");
        }
        try {
            this.subscription = this.initSubscription(listener);
            this.subscription.subscribe(channels);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    <T> T failsafeReadScanValues(List<?> source, Converter converter) {
        try {
            return (T)(converter != null ? converter.convert(source) : source);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public void setPipeliningFlushPolicy(PipeliningFlushPolicy pipeliningFlushPolicy) {
        Assert.notNull((Object)pipeliningFlushPolicy, (String)"PipeliningFlushingPolicy must not be null!");
        this.pipeliningFlushPolicy = pipeliningFlushPolicy;
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
    }

    protected StatefulRedisPubSubConnection<byte[], byte[]> switchToPubSub() {
        this.close();
        return this.connectionProvider.getConnection(StatefulRedisPubSubConnection.class);
    }

    private LettuceSubscription initSubscription(MessageListener listener) {
        return this.doCreateSubscription(listener, this.switchToPubSub(), this.connectionProvider);
    }

    protected LettuceSubscription doCreateSubscription(MessageListener listener, StatefulRedisPubSubConnection<byte[], byte[]> connection, LettuceConnectionProvider connectionProvider) {
        return new LettuceSubscription(listener, connection, connectionProvider);
    }

    void pipeline(LettuceResult result) {
        if (this.flushState != null) {
            this.flushState.onCommand(this.getOrCreateDedicatedConnection());
        }
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.ppline.add(result);
        }
    }

    void transaction(FutureResult<?> result) {
        this.txResults.add(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        if (this.isQueueing()) {
            return this.getAsyncDedicatedConnection();
        }
        if (this.asyncSharedConn != null && this.asyncSharedConn instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)this.asyncSharedConn).async();
        }
        return this.getAsyncDedicatedConnection();
    }

    protected RedisClusterCommands<byte[], byte[]> getConnection() {
        if (this.isQueueing()) {
            return this.getDedicatedConnection();
        }
        if (this.asyncSharedConn != null) {
            if (this.asyncSharedConn instanceof StatefulRedisConnection) {
                return ((StatefulRedisConnection)this.asyncSharedConn).sync();
            }
            if (this.asyncSharedConn instanceof StatefulRedisClusterConnection) {
                return ((StatefulRedisClusterConnection)this.asyncSharedConn).sync();
            }
        }
        return this.getDedicatedConnection();
    }

    private RedisAsyncCommands<byte[], byte[]> getAsyncDedicatedRedisCommands() {
        return (RedisAsyncCommands)this.getAsyncDedicatedConnection();
    }

    RedisClusterCommands<byte[], byte[]> getDedicatedConnection() {
        StatefulConnection<byte[], byte[]> connection = this.getOrCreateDedicatedConnection();
        if (connection instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)connection).sync();
        }
        if (connection instanceof StatefulRedisClusterConnection) {
            return ((StatefulRedisClusterConnection)connection).sync();
        }
        throw new IllegalStateException(String.format("%s is not a supported connection type.", connection.getClass().getName()));
    }

    protected RedisClusterAsyncCommands<byte[], byte[]> getAsyncDedicatedConnection() {
        StatefulConnection<byte[], byte[]> connection = this.getOrCreateDedicatedConnection();
        if (connection instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)connection).async();
        }
        if (this.asyncDedicatedConn instanceof StatefulRedisClusterConnection) {
            return ((StatefulRedisClusterConnection)connection).async();
        }
        throw new IllegalStateException(String.format("%s is not a supported connection type.", connection.getClass().getName()));
    }

    private StatefulConnection<byte[], byte[]> getOrCreateDedicatedConnection() {
        if (this.asyncDedicatedConn == null) {
            this.asyncDedicatedConn = this.doGetAsyncDedicatedConnection();
        }
        return this.asyncDedicatedConn;
    }

    private RedisCommands<byte[], byte[]> getDedicatedRedisCommands() {
        return (RedisCommands)this.getDedicatedConnection();
    }

    protected StatefulConnection<byte[], byte[]> doGetAsyncDedicatedConnection() {
        StatefulConnection connection = this.connectionProvider.getConnection(StatefulConnection.class);
        if (this.customizedDatabaseIndex()) {
            this.potentiallySelectDatabase(this.dbIndex);
        }
        return connection;
    }

    private boolean customizedDatabaseIndex() {
        return this.defaultDbIndex != this.dbIndex;
    }

    private void potentiallySelectDatabase(int dbIndex) {
        if (this.asyncDedicatedConn instanceof StatefulRedisConnection) {
            ((StatefulRedisConnection)this.asyncDedicatedConn).sync().select(dbIndex);
        }
    }

    ScanCursor getScanCursor(long cursorId) {
        return ScanCursor.of((String)Long.toString(cursorId));
    }

    private void validateCommandIfRunningInTransactionMode(CommandType cmd, byte[] ... args) {
        if (this.isQueueing()) {
            this.validateCommand(cmd, args);
        }
    }

    private void validateCommand(CommandType cmd, byte[] ... args) {
        RedisCommand redisCommand = RedisCommand.failsafeCommandLookup(cmd.name());
        if (!RedisCommand.UNKNOWN.equals((Object)redisCommand) && redisCommand.requiresArguments()) {
            try {
                redisCommand.validateArgumentCount(args != null ? args.length : 0);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDataAccessApiUsageException(String.format("Validation failed for %s command.", cmd), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isActive(RedisNode node) {
        StatefulRedisSentinelConnection<String, String> connection = null;
        try {
            connection = this.getConnection(node);
            boolean bl = connection.sync().ping().equalsIgnoreCase("pong");
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                this.connectionProvider.release((StatefulConnection<?, ?>)connection);
            }
        }
    }

    private RedisURI getRedisURI(RedisNode node) {
        return RedisURI.Builder.redis((String)node.getHost(), (int)node.getPort()).build();
    }

    @Override
    protected RedisSentinelConnection getSentinelConnection(RedisNode sentinel) {
        StatefulRedisSentinelConnection<String, String> connection = this.getConnection(sentinel);
        return new LettuceSentinelConnection(connection);
    }

    private StatefulRedisSentinelConnection<String, String> getConnection(RedisNode sentinel) {
        return ((LettuceConnectionProvider.TargetAware)((Object)this.connectionProvider)).getConnection(StatefulRedisSentinelConnection.class, this.getRedisURI(sentinel));
    }

    LettuceConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    private static class BufferedFlushing
    implements PipeliningFlushState {
        private final AtomicLong commands = new AtomicLong();
        private final int flushAfter;

        public BufferedFlushing(int flushAfter) {
            this.flushAfter = flushAfter;
        }

        @Override
        public void onOpen(StatefulConnection<?, ?> connection) {
            connection.setAutoFlushCommands(false);
        }

        @Override
        public void onCommand(StatefulConnection<?, ?> connection) {
            if (this.commands.incrementAndGet() % (long)this.flushAfter == 0L) {
                connection.flushCommands();
            }
        }

        @Override
        public void onClose(StatefulConnection<?, ?> connection) {
            connection.flushCommands();
            connection.setAutoFlushCommands(true);
        }
    }

    private static enum FlushOnClose implements PipeliningFlushPolicy,
    PipeliningFlushState
    {
        INSTANCE;


        @Override
        public PipeliningFlushState newPipeline() {
            return INSTANCE;
        }

        @Override
        public void onOpen(StatefulConnection<?, ?> connection) {
            connection.setAutoFlushCommands(false);
        }

        @Override
        public void onCommand(StatefulConnection<?, ?> connection) {
        }

        @Override
        public void onClose(StatefulConnection<?, ?> connection) {
            connection.flushCommands();
            connection.setAutoFlushCommands(true);
        }
    }

    private static enum FlushEachCommand implements PipeliningFlushPolicy,
    PipeliningFlushState
    {
        INSTANCE;


        @Override
        public PipeliningFlushState newPipeline() {
            return INSTANCE;
        }

        @Override
        public void onOpen(StatefulConnection<?, ?> connection) {
        }

        @Override
        public void onCommand(StatefulConnection<?, ?> connection) {
        }

        @Override
        public void onClose(StatefulConnection<?, ?> connection) {
        }
    }

    public static interface PipeliningFlushState {
        public void onOpen(StatefulConnection<?, ?> var1);

        public void onCommand(StatefulConnection<?, ?> var1);

        public void onClose(StatefulConnection<?, ?> var1);
    }

    public static interface PipeliningFlushPolicy {
        public static PipeliningFlushPolicy flushEachCommand() {
            return FlushEachCommand.INSTANCE;
        }

        public static PipeliningFlushPolicy flushOnClose() {
            return FlushOnClose.INSTANCE;
        }

        public static PipeliningFlushPolicy buffered(int bufferSize) {
            Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0, (String)"Buffer size must be greater than 0");
            return () -> new BufferedFlushing(bufferSize);
        }

        public PipeliningFlushState newPipeline();
    }

    static class LettucePoolConnectionProvider
    implements LettuceConnectionProvider {
        private final LettucePool pool;

        @Override
        public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
            return (T)((StatefulConnection)connectionType.cast(this.pool.getResource()));
        }

        @Override
        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
            throw new UnsupportedOperationException("Async operations not supported!");
        }

        @Override
        public void release(StatefulConnection<?, ?> connection) {
            if (connection.isOpen()) {
                StatefulRedisConnection redisConnection;
                if (connection instanceof StatefulRedisConnection && (redisConnection = (StatefulRedisConnection)connection).isMulti()) {
                    redisConnection.async().discard();
                }
                this.pool.returnResource(connection);
            } else {
                this.pool.returnBrokenResource(connection);
            }
        }

        public LettucePoolConnectionProvider(LettucePool pool) {
            this.pool = pool;
        }
    }

    static class TypeHints {
        private static final Map<CommandType, Class<? extends CommandOutput>> COMMAND_OUTPUT_TYPE_MAPPING = new HashMap<CommandType, Class<? extends CommandOutput>>();
        private static final Map<Class<?>, Constructor<CommandOutput>> CONSTRUCTORS = new ConcurrentHashMap();

        TypeHints() {
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITCOUNT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITOP, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BITPOS, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DBSIZE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DECR, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DECRBY, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DEL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETBIT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HDEL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HINCRBY, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HLEN, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCR, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCRBY, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LINSERT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LLEN, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPUSH, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPUSHX, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LREM, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PTTL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PUBLISH, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPUSH, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPUSHX, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SADD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SCARD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SDIFFSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETBIT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETRANGE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SINTERSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SREM, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SUNIONSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.STRLEN, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TTL, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZADD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZCOUNT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZINTERSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANK, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREM, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYRANK, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREMRANGEBYSCORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANK, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZUNIONSTORE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PFCOUNT, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PFMERGE, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PFADD, IntegerOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HINCRBYFLOAT, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INCRBYFLOAT, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MGET, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZINCRBY, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZSCORE, DoubleOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HGETALL, MapOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HKEYS, KeyListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.KEYS, KeyListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BRPOP, KeyValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BRPOPLPUSH, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ECHO, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GET, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETRANGE, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.GETSET, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HGET, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LINDEX, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LPOP, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RANDOMKEY, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RENAME, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPOP, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RPOPLPUSH, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SPOP, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SRANDMEMBER, ValueOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BGREWRITEAOF, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.BGSAVE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.CLIENT, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DEBUG, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.DISCARD, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.FLUSHALL, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.FLUSHDB, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HMSET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.INFO, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LSET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LTRIM, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MIGRATE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MSET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.QUIT, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RESTORE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SAVE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SELECT, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SET, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETEX, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SHUTDOWN, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SLAVEOF, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SYNC, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.TYPE, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.WATCH, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.UNWATCH, StatusOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HMGET, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MGET, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HVALS, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LRANGE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SORT, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZRANGEBYSCORE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.ZREVRANGEBYSCORE, ValueListOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXISTS, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXPIRE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXPIREAT, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HEXISTS, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSET, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.HSETNX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MOVE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MSETNX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PERSIST, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PEXPIRE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.PEXPIREAT, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.RENAMENX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SETNX, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SISMEMBER, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SMOVE, BooleanOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.EXEC, MultiOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.MULTI, MultiOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.LASTSAVE, DateOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SDIFF, ValueSetOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SINTER, ValueSetOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SMEMBERS, ValueSetOutput.class);
            COMMAND_OUTPUT_TYPE_MAPPING.put(CommandType.SUNION, ValueSetOutput.class);
        }

        public CommandOutput getTypeHint(CommandType type) {
            return this.getTypeHint(type, (CommandOutput)new ByteArrayOutput(CODEC));
        }

        public CommandOutput getTypeHint(CommandType type, CommandOutput defaultType) {
            if (type == null || !COMMAND_OUTPUT_TYPE_MAPPING.containsKey(type)) {
                return defaultType;
            }
            CommandOutput outputType = this.instanciateCommandOutput(COMMAND_OUTPUT_TYPE_MAPPING.get(type));
            return outputType != null ? outputType : defaultType;
        }

        private CommandOutput<?, ?, ?> instanciateCommandOutput(Class<? extends CommandOutput> type) {
            Assert.notNull(type, (String)"Cannot create instance for 'null' type.");
            Constructor constructor = CONSTRUCTORS.get(type);
            if (constructor == null) {
                constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{RedisCodec.class});
                CONSTRUCTORS.put(type, constructor);
            }
            return (CommandOutput)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{CODEC});
        }
    }

    private class LettuceTransactionResultConverter<T>
    extends TransactionResultConverter<T> {
        public LettuceTransactionResultConverter(Queue<FutureResult<T>> txResults, Converter<Exception, DataAccessException> exceptionConverter) {
            super(txResults, exceptionConverter);
        }

        @Override
        public List<Object> convert(List<Object> execResults) {
            if (execResults.isEmpty()) {
                return null;
            }
            return super.convert(execResults);
        }
    }
}

