/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

public abstract class FutureResult<T> {
    protected T resultHolder;
    protected boolean status = false;
    @Nullable
    protected Converter converter;

    public FutureResult(T resultHolder) {
        this.resultHolder = resultHolder;
    }

    public FutureResult(T resultHolder, Converter converter) {
        this.resultHolder = resultHolder;
        this.converter = converter;
    }

    public T getResultHolder() {
        return this.resultHolder;
    }

    @Nullable
    public Object convert(@Nullable Object result) {
        if (result == null) {
            return null;
        }
        return this.converter != null ? this.converter.convert(result) : result;
    }

    @Nullable
    public Converter getConverter() {
        return this.converter;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    @Nullable
    public abstract Object get();
}

