/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import com.mongodb.client.MongoCollection;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mongodb.core.convert.DocumentReferenceSource;
import org.springframework.data.mongodb.core.convert.ReferenceLoader;
import org.springframework.data.mongodb.core.convert.ReferenceResolver;
import org.springframework.data.mongodb.core.mapping.DocumentReference;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.data.mongodb.util.spel.ExpressionUtils;
import org.springframework.data.util.Streamable;
import org.springframework.expression.EvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class ReferenceLookupDelegate {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final SpELContext spELContext;
    private final ParameterBindingDocumentCodec codec;

    public ReferenceLookupDelegate(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, SpELContext spELContext) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null");
        Assert.notNull((Object)spELContext, (String)"SpELContext must not be null");
        this.mappingContext = mappingContext;
        this.spELContext = spELContext;
        this.codec = new ParameterBindingDocumentCodec();
    }

    @Nullable
    public Object readReference(MongoPersistentProperty property, Object source, LookupFunction lookupFunction, ReferenceResolver.MongoEntityReader entityReader) {
        Object object;
        if (source instanceof DocumentReferenceSource) {
            DocumentReferenceSource documentReferenceSource = (DocumentReferenceSource)source;
            object = documentReferenceSource.getTargetSource();
        } else {
            object = source;
        }
        Object value = object;
        Iterable<Document> result = this.retrieveRawDocuments(property, source, lookupFunction, value);
        if (result == null) {
            return null;
        }
        if (property.isCollectionLike()) {
            return entityReader.read(result, property.getTypeInformation());
        }
        if (!result.iterator().hasNext()) {
            return null;
        }
        Document resultValue = result.iterator().next();
        return resultValue != null ? entityReader.read(resultValue, property.getTypeInformation()) : null;
    }

    @Nullable
    private Iterable<Document> retrieveRawDocuments(MongoPersistentProperty property, Object source, LookupFunction lookupFunction, Object value) {
        ReferenceLoader.DocumentReferenceQuery filter = this.computeFilter(property, source, this.spELContext);
        if (filter instanceof ReferenceLoader.NoResultsFilter) {
            return Collections.emptyList();
        }
        ReferenceResolver.ReferenceCollection referenceCollection = this.computeReferenceContext(property, value, this.spELContext);
        return lookupFunction.apply(filter, referenceCollection);
    }

    private ReferenceResolver.ReferenceCollection computeReferenceContext(MongoPersistentProperty property, Object value, SpELContext spELContext) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            Iterator iterator = iterable.iterator();
            Object object = value = iterator.hasNext() ? iterator.next() : new Document();
        }
        if (value instanceof DBRef) {
            DBRef dbRef = (DBRef)value;
            return ReferenceResolver.ReferenceCollection.fromDBRef(dbRef);
        }
        String collection = ((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property.getAssociationTargetType())).getCollection();
        if (value instanceof Document) {
            Document documentPointer = (Document)value;
            if (property.isDocumentReference()) {
                ParameterBindingContext bindingContext = this.bindingContext(property, value, spELContext);
                DocumentReference documentReference = property.getDocumentReference();
                String targetDatabase = this.parseValueOrGet(documentReference.db(), bindingContext, () -> (String)documentPointer.get((Object)"db", String.class));
                String targetCollection = this.parseValueOrGet(documentReference.collection(), bindingContext, () -> (String)documentPointer.get((Object)"collection", (Object)collection));
                return new ReferenceResolver.ReferenceCollection(targetDatabase, targetCollection);
            }
            return new ReferenceResolver.ReferenceCollection(documentPointer.getString((Object)"db"), (String)documentPointer.get((Object)"collection", (Object)collection));
        }
        if (property.isDocumentReference()) {
            ParameterBindingContext bindingContext = this.bindingContext(property, value, spELContext);
            DocumentReference documentReference = property.getDocumentReference();
            String targetDatabase = this.parseValueOrGet(documentReference.db(), bindingContext, () -> null);
            String targetCollection = this.parseValueOrGet(documentReference.collection(), bindingContext, () -> collection);
            return new ReferenceResolver.ReferenceCollection(targetDatabase, targetCollection);
        }
        return new ReferenceResolver.ReferenceCollection(null, collection);
    }

    private <T> T parseValueOrGet(String value, ParameterBindingContext bindingContext, Supplier<T> defaultValue) {
        if (!StringUtils.hasText((String)value)) {
            return defaultValue.get();
        }
        if (!BsonUtils.isJsonDocument(value) && value.contains("?#{")) {
            String s = "{ 'target-value' : " + value + "}";
            Object evaluated = this.codec.decode(s, bindingContext).get((Object)"target-value");
            return (T)(evaluated != null ? evaluated : defaultValue.get());
        }
        if (BsonUtils.isJsonDocument(value)) {
            return (T)this.codec.decode(value, bindingContext);
        }
        if (!value.startsWith("#") && ExpressionUtils.detectExpression(value) == null) {
            return (T)value;
        }
        Object evaluated = bindingContext.evaluateExpression(value);
        return (T)(evaluated != null ? evaluated : defaultValue.get());
    }

    ParameterBindingContext bindingContext(MongoPersistentProperty property, Object source, SpELContext spELContext) {
        ValueProvider valueProvider = this.valueProviderFor(DocumentReferenceSource.getTargetSource(source));
        return new ParameterBindingContext(valueProvider, spELContext.getParser(), () -> this.evaluationContextFor(property, source, spELContext));
    }

    ValueProvider valueProviderFor(Object source) {
        return index -> {
            if (source instanceof Document) {
                Document document = (Document)source;
                return Streamable.of((Iterable)document.values()).toList().get(index);
            }
            return source;
        };
    }

    EvaluationContext evaluationContextFor(MongoPersistentProperty property, Object source, SpELContext spELContext) {
        Object target;
        if (source instanceof DocumentReferenceSource) {
            DocumentReferenceSource documentReferenceSource = (DocumentReferenceSource)source;
            v0 = documentReferenceSource.getTargetSource();
        } else {
            v0 = target = source;
        }
        if (target == null) {
            target = new Document();
        }
        EvaluationContext ctx = spELContext.getEvaluationContext(target);
        ctx.setVariable("target", target);
        ctx.setVariable("self", DocumentReferenceSource.getSelf(source));
        ctx.setVariable(property.getName(), target);
        return ctx;
    }

    ReferenceLoader.DocumentReferenceQuery computeFilter(MongoPersistentProperty property, Object source, SpELContext spELContext) {
        DocumentReference documentReference = property.isDocumentReference() ? property.getDocumentReference() : ReferenceEmulatingDocumentReference.INSTANCE;
        String lookup = documentReference.lookup();
        Object value = DocumentReferenceSource.getTargetSource(source);
        Document sort = this.parseValueOrGet(documentReference.sort(), this.bindingContext(property, source, spELContext), Document::new);
        if (property.isCollectionLike() && (value instanceof Collection || value == null)) {
            if (value == null) {
                return new ListDocumentReferenceQuery(this.codec.decode(lookup, this.bindingContext(property, source, spELContext)), sort);
            }
            Collection objects = (Collection)value;
            if (objects.isEmpty()) {
                return ReferenceLoader.DocumentReferenceQuery.forNoResult();
            }
            ArrayList<Document> ors = new ArrayList<Document>(objects.size());
            for (Object entry : objects) {
                Document decoded = this.codec.decode(lookup, this.bindingContext(property, entry, spELContext));
                ors.add(decoded);
            }
            return new ListDocumentReferenceQuery(new Document("$or", ors), sort);
        }
        if (property.isMap() && value instanceof Map) {
            if (ObjectUtils.isEmpty((Object)value)) {
                return ReferenceLoader.DocumentReferenceQuery.forNoResult();
            }
            Set entries = ((Map)value).entrySet();
            LinkedHashMap<Object, Document> filterMap = new LinkedHashMap<Object, Document>(entries.size());
            for (Map.Entry entry : entries) {
                Document decoded = this.codec.decode(lookup, this.bindingContext(property, entry.getValue(), spELContext));
                filterMap.put(entry.getKey(), decoded);
            }
            return new MapDocumentReferenceQuery(new Document("$or", filterMap.values()), sort, filterMap);
        }
        return new SingleDocumentReferenceQuery(this.codec.decode(lookup, this.bindingContext(property, source, spELContext)), sort);
    }

    @FunctionalInterface
    static interface LookupFunction {
        public Iterable<Document> apply(ReferenceLoader.DocumentReferenceQuery var1, ReferenceResolver.ReferenceCollection var2);
    }

    static enum ReferenceEmulatingDocumentReference implements DocumentReference
    {
        INSTANCE;


        @Override
        public Class<? extends Annotation> annotationType() {
            return DocumentReference.class;
        }

        @Override
        public String db() {
            return "";
        }

        @Override
        public String collection() {
            return "";
        }

        @Override
        public String lookup() {
            return "{ '_id' : ?#{#target} }";
        }

        @Override
        public String sort() {
            return "";
        }

        @Override
        public boolean lazy() {
            return false;
        }
    }

    static class ListDocumentReferenceQuery
    implements ReferenceLoader.DocumentReferenceQuery {
        private final Document query;
        private final Document sort;

        public ListDocumentReferenceQuery(Document query, Document sort) {
            this.query = query;
            this.sort = sort;
        }

        @Override
        public Iterable<Document> restoreOrder(Iterable<Document> documents) {
            List list;
            List target;
            List list2 = target = documents instanceof List ? (list = (List)documents) : Streamable.of(documents).toList();
            if (!this.sort.isEmpty() || !this.query.containsKey((Object)"$or")) {
                return target;
            }
            List ors = (List)this.query.get((Object)"$or", List.class);
            return target.stream().sorted((o1, o2) -> this.compareAgainstReferenceIndex(ors, (Document)o1, (Document)o2)).collect(Collectors.toList());
        }

        public Document getQuery() {
            return this.query;
        }

        public Document getSort() {
            return this.sort;
        }

        int compareAgainstReferenceIndex(List<Document> referenceList, Document document1, Document document2) {
            for (Document document : referenceList) {
                Set entries = document.entrySet();
                if (document1.entrySet().containsAll(entries)) {
                    return -1;
                }
                if (!document2.entrySet().containsAll(entries)) continue;
                return 1;
            }
            return referenceList.size();
        }
    }

    static class MapDocumentReferenceQuery
    implements ReferenceLoader.DocumentReferenceQuery {
        private final Document query;
        private final Document sort;
        private final Map<Object, Document> filterOrderMap;

        public MapDocumentReferenceQuery(Document query, Document sort, Map<Object, Document> filterOrderMap) {
            this.query = query;
            this.sort = sort;
            this.filterOrderMap = filterOrderMap;
        }

        @Override
        public Bson getQuery() {
            return this.query;
        }

        @Override
        public Bson getSort() {
            return this.sort;
        }

        @Override
        public Iterable<Document> restoreOrder(Iterable<Document> documents) {
            List list;
            LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
            List collected = documents instanceof List ? (list = (List)documents) : Streamable.of(documents).toList();
            for (Map.Entry<Object, Document> filterMapping : this.filterOrderMap.entrySet()) {
                Optional<Document> first = collected.stream().filter(it -> it.entrySet().containsAll(((Document)filterMapping.getValue()).entrySet())).findFirst();
                targetMap.put(filterMapping.getKey().toString(), first.orElse(null));
            }
            return Collections.singleton(new Document(targetMap));
        }
    }

    static class SingleDocumentReferenceQuery
    implements ReferenceLoader.DocumentReferenceQuery {
        private final Document query;
        private final Document sort;

        public SingleDocumentReferenceQuery(Document query, Document sort) {
            this.query = query;
            this.sort = sort;
        }

        @Override
        public Bson getQuery() {
            return this.query;
        }

        public Document getSort() {
            return this.sort;
        }

        @Override
        public Iterable<Document> apply(MongoCollection<Document> collection) {
            Document result = (Document)collection.find(this.getQuery()).sort((Bson)this.getSort()).limit(1).first();
            return result != null ? Collections.singleton(result) : Collections.emptyList();
        }
    }
}

