/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.util.Assert;

public class ExpressionTransformationContextSupport<T extends ExpressionNode> {
    private final T currentNode;
    private final ExpressionNode parentNode;
    private final DBObject previousOperationObject;

    public ExpressionTransformationContextSupport(T currentNode, ExpressionNode parentNode, DBObject previousOperationObject) {
        Assert.notNull(currentNode, (String)"currentNode must not be null!");
        this.currentNode = currentNode;
        this.parentNode = parentNode;
        this.previousOperationObject = previousOperationObject;
    }

    public T getCurrentNode() {
        return this.currentNode;
    }

    public ExpressionNode getParentNode() {
        return this.parentNode;
    }

    public DBObject getPreviousOperationObject() {
        return this.previousOperationObject;
    }

    public boolean hasPreviousOperation() {
        return this.getPreviousOperationObject() != null;
    }

    public boolean parentIsSameOperation() {
        return this.parentNode == null ? false : ((ExpressionNode)this.currentNode).isOfSameTypeAs(this.parentNode);
    }

    public DBObject addToPreviousOperation(Object value) {
        this.extractArgumentListFrom(this.previousOperationObject).add(value);
        return this.previousOperationObject;
    }

    public Object addToPreviousOrReturn(Object value) {
        return this.hasPreviousOperation() ? this.addToPreviousOperation(value) : value;
    }

    private BasicDBList extractArgumentListFrom(DBObject context) {
        return (BasicDBList)context.get((String)context.keySet().iterator().next());
    }
}

