/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.event.MappingContextEvent;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.index.GeospatialIndex;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoPersistentEntityIndexCreator
implements ApplicationListener<MappingContextEvent<MongoPersistentEntity<MongoPersistentProperty>, MongoPersistentProperty>> {
    private static final Log log = LogFactory.getLog(MongoPersistentEntityIndexCreator.class);
    private final Map<Class<?>, Boolean> classesSeen = new ConcurrentHashMap();
    private final MongoDbFactory mongoDbFactory;

    public MongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, MongoDbFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory);
        Assert.notNull((Object)((Object)mappingContext));
        this.mongoDbFactory = mongoDbFactory;
        for (BasicMongoPersistentEntity entity : mappingContext.getPersistentEntities()) {
            this.checkForIndexes(entity);
        }
    }

    public void onApplicationEvent(MappingContextEvent<MongoPersistentEntity<MongoPersistentProperty>, MongoPersistentProperty> event) {
        PersistentEntity entity = event.getPersistentEntity();
        if (entity instanceof MongoPersistentEntity) {
            this.checkForIndexes((MongoPersistentEntity)event.getPersistentEntity());
        }
    }

    protected void checkForIndexes(final MongoPersistentEntity<?> entity) {
        Class type = entity.getType();
        if (!this.classesSeen.containsKey(type)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Analyzing class " + type + " for index information."));
            }
            if (type.isAnnotationPresent(CompoundIndexes.class)) {
                CompoundIndexes indexes = type.getAnnotation(CompoundIndexes.class);
                for (CompoundIndex index : indexes.value()) {
                    String indexColl = index.collection();
                    if ("".equals(indexColl)) {
                        indexColl = entity.getCollection();
                    }
                    this.ensureIndex(indexColl, index.name(), index.def(), index.direction(), index.unique(), index.dropDups(), index.sparse());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Created compound index " + index));
                }
            }
            entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

                public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                    Field field = persistentProperty.getField();
                    if (field.isAnnotationPresent(Indexed.class)) {
                        Indexed index = field.getAnnotation(Indexed.class);
                        String name = index.name();
                        if (!StringUtils.hasText((String)name)) {
                            name = persistentProperty.getFieldName();
                        } else if (!name.equals(field.getName()) && index.unique() && !index.sparse() && log.isWarnEnabled()) {
                            log.warn((Object)("The index name " + name + " doesn't match this property name: " + field.getName() + ". Setting sparse=true on this index will prevent errors when inserting documents."));
                        }
                        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : entity.getCollection();
                        MongoPersistentEntityIndexCreator.this.ensureIndex(collection, name, null, index.direction(), index.unique(), index.dropDups(), index.sparse());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Created property index " + index));
                        }
                    } else if (field.isAnnotationPresent(GeoSpatialIndexed.class)) {
                        GeoSpatialIndexed index = field.getAnnotation(GeoSpatialIndexed.class);
                        GeospatialIndex indexObject = new GeospatialIndex(persistentProperty.getFieldName());
                        indexObject.withMin(index.min()).withMax(index.max());
                        indexObject.named(StringUtils.hasText((String)index.name()) ? index.name() : field.getName());
                        String collection = StringUtils.hasText((String)index.collection()) ? index.collection() : entity.getCollection();
                        MongoPersistentEntityIndexCreator.this.mongoDbFactory.getDb().getCollection(collection).ensureIndex(indexObject.getIndexKeys(), indexObject.getIndexOptions());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Created %s for entity %s in collection %s! ", indexObject, entity.getType(), collection));
                        }
                    }
                }
            });
            this.classesSeen.put(type, true);
        }
    }

    protected void ensureIndex(String collection, String name, String def, IndexDirection direction, boolean unique, boolean dropDups, boolean sparse) {
        DBObject defObj;
        if (null != def) {
            defObj = (DBObject)JSON.parse((String)def);
        } else {
            defObj = new BasicDBObject();
            defObj.put(name, (Object)(direction == IndexDirection.ASCENDING ? 1 : -1));
        }
        BasicDBObject opts = new BasicDBObject();
        opts.put("name", (Object)name);
        opts.put("dropDups", (Object)dropDups);
        opts.put("sparse", (Object)sparse);
        opts.put("unique", (Object)unique);
        this.mongoDbFactory.getDb().getCollection(collection).ensureIndex(defObj, (DBObject)opts);
    }
}

