/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.JpqlBaseVisitor;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryRenderer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokens;

class JpqlQueryIntrospector
extends JpqlBaseVisitor<Void>
implements ParsedQueryIntrospector<QueryInformation> {
    private final JpqlQueryRenderer renderer = new JpqlQueryRenderer();
    @Nullable
    private String primaryFromAlias = null;
    @Nullable
    private List<QueryToken> projection;
    private boolean projectionProcessed;
    private boolean hasConstructorExpression = false;

    JpqlQueryIntrospector() {
    }

    @Override
    public QueryInformation getParsedQueryInformation() {
        return new QueryInformation(this.primaryFromAlias, this.projection == null ? Collections.emptyList() : this.projection, this.hasConstructorExpression);
    }

    @Override
    public Void visitRange_variable_declaration(JpqlParser.Range_variable_declarationContext ctx) {
        if (this.primaryFromAlias == null) {
            this.primaryFromAlias = JpqlQueryIntrospector.capturePrimaryAlias(ctx);
        }
        return (Void)super.visitRange_variable_declaration(ctx);
    }

    @Override
    public Void visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        if (!this.projectionProcessed) {
            this.projection = JpqlQueryIntrospector.captureSelectItems(ctx.select_item(), this.renderer);
            this.projectionProcessed = true;
        }
        return (Void)super.visitSelect_clause(ctx);
    }

    @Override
    public Void visitConstructor_expression(JpqlParser.Constructor_expressionContext ctx) {
        this.hasConstructorExpression = true;
        return (Void)super.visitConstructor_expression(ctx);
    }

    private static String capturePrimaryAlias(JpqlParser.Range_variable_declarationContext ctx) {
        return ctx.identification_variable() != null ? ctx.identification_variable().getText() : ctx.entity_name().getText();
    }

    private static List<QueryToken> captureSelectItems(List<JpqlParser.Select_itemContext> selections, JpqlQueryRenderer itemRenderer) {
        ArrayList<QueryToken> selectItemTokens = new ArrayList<QueryToken>(selections.size() * 2);
        for (JpqlParser.Select_itemContext selection : selections) {
            if (!selectItemTokens.isEmpty()) {
                selectItemTokens.add(QueryTokens.TOKEN_COMMA);
            }
            selectItemTokens.add(QueryTokens.token(QueryRenderer.from(itemRenderer.visitSelect_item(selection)).render()));
        }
        return selectItemTokens;
    }
}

