/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import java.util.List;
import org.springframework.data.domain.Limit;
import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.PreprocessedQuery;
import org.springframework.data.jpa.repository.query.QueryProvider;

abstract class StringAotQuery
extends AotQuery {
    private StringAotQuery(List<ParameterBinding> parameterBindings) {
        super(parameterBindings);
    }

    static StringAotQuery of(DeclaredQuery query) {
        if (query instanceof PreprocessedQuery) {
            PreprocessedQuery pq = (PreprocessedQuery)query;
            return new DeclaredAotQuery(pq, false);
        }
        return new DeclaredAotQuery(PreprocessedQuery.parse(query), false);
    }

    static StringAotQuery jpqlQuery(String queryString) {
        return StringAotQuery.of(DeclaredQuery.jpqlQuery(queryString));
    }

    public static StringAotQuery jpqlQuery(String queryString, List<ParameterBinding> bindings, Limit resultLimit, boolean delete, boolean exists) {
        return new DerivedAotQuery(queryString, bindings, resultLimit, delete, exists);
    }

    static StringAotQuery nativeQuery(String queryString) {
        return StringAotQuery.of(DeclaredQuery.nativeQuery(queryString));
    }

    public abstract DeclaredQuery getQuery();

    public String getQueryString() {
        return this.getQuery().getQueryString();
    }

    public abstract boolean hasConstructorExpressionOrDefaultProjection();

    public abstract StringAotQuery withConstructorExpressionOrDefaultProjection();

    public String toString() {
        return this.getQueryString();
    }

    public abstract StringAotQuery rewrite(QueryProvider var1);

    private static class DeclaredAotQuery
    extends StringAotQuery {
        private final PreprocessedQuery query;
        private final boolean constructorExpressionOrDefaultProjection;

        DeclaredAotQuery(PreprocessedQuery query, boolean constructorExpressionOrDefaultProjection) {
            super(query.getBindings());
            this.query = query;
            this.constructorExpressionOrDefaultProjection = constructorExpressionOrDefaultProjection;
        }

        @Override
        public PreprocessedQuery getQuery() {
            return this.query;
        }

        @Override
        public String getQueryString() {
            return this.query.getQueryString();
        }

        @Override
        public boolean isNative() {
            return this.query.isNative();
        }

        @Override
        public boolean hasConstructorExpressionOrDefaultProjection() {
            return this.constructorExpressionOrDefaultProjection;
        }

        @Override
        public StringAotQuery withConstructorExpressionOrDefaultProjection() {
            return new DeclaredAotQuery(this.query, true);
        }

        @Override
        public StringAotQuery rewrite(QueryProvider rewritten) {
            return new DeclaredAotQuery(this.query.rewrite(rewritten.getQueryString()), this.constructorExpressionOrDefaultProjection);
        }
    }

    private static class DerivedAotQuery
    extends StringAotQuery {
        private final String queryString;
        private final Limit limit;
        private final boolean delete;
        private final boolean exists;

        DerivedAotQuery(String queryString, List<ParameterBinding> parameterBindings, Limit limit, boolean delete, boolean exists) {
            super(parameterBindings);
            this.queryString = queryString;
            this.limit = limit;
            this.delete = delete;
            this.exists = exists;
        }

        @Override
        public DeclaredQuery getQuery() {
            return DeclaredQuery.jpqlQuery(this.queryString);
        }

        @Override
        public String getQueryString() {
            return this.queryString;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public Limit getLimit() {
            return this.limit;
        }

        @Override
        public boolean isDelete() {
            return this.delete;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public boolean hasConstructorExpressionOrDefaultProjection() {
            return false;
        }

        @Override
        public StringAotQuery withConstructorExpressionOrDefaultProjection() {
            return this;
        }

        @Override
        public StringAotQuery rewrite(QueryProvider rewritten) {
            return new DerivedAotQuery(rewritten.getQueryString(), this.getParameterBindings(), this.getLimit(), this.delete, this.exists);
        }
    }
}

