/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.ManagedType;
import org.springframework.data.jpa.repository.JpaContext;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class DefaultJpaContext
implements JpaContext {
    private final MultiValueMap<Class<?>, EntityManager> entityManagers;

    public DefaultJpaContext(Set<EntityManager> entityManagers) {
        Assert.notNull(entityManagers, (String)"EntityManagers must not be null!");
        Assert.notEmpty(entityManagers, (String)"EntityManagers must not be empty!");
        this.entityManagers = new LinkedMultiValueMap();
        for (EntityManager em : entityManagers) {
            for (ManagedType managedType : em.getMetamodel().getManagedTypes()) {
                this.entityManagers.add((Object)managedType.getJavaType(), (Object)em);
            }
        }
    }

    @Override
    public EntityManager getEntityManagerByManagedType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        if (!this.entityManagers.containsKey(type)) {
            throw new IllegalArgumentException(String.format("%s is not a managed type!", type));
        }
        List candidates = (List)this.entityManagers.get(type);
        if (candidates.size() == 1) {
            return (EntityManager)candidates.get(0);
        }
        throw new IllegalArgumentException(String.format("%s managed by more than one EntityManagers: %s!", type.getName(), candidates));
    }
}

