/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.IdGeneratingEntityCallback;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.jdbc.core.dialect.DialectResolver;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.jdbc.repository.config.JdbcConfiguration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.RelationalManagedTypes;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration(proxyBeanMethods=false)
public class AbstractJdbcConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private QueryMappingConfiguration queryMappingConfiguration = QueryMappingConfiguration.EMPTY;

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return mappingBasePackage == null ? List.of() : List.of(mappingBasePackage.getName());
    }

    @Bean
    public RelationalManagedTypes jdbcManagedTypes() throws ClassNotFoundException {
        return RelationalManagedTypes.fromIterable(this.getInitialEntitySet());
    }

    @Bean
    public JdbcMappingContext jdbcMappingContext(Optional<NamingStrategy> namingStrategy, JdbcCustomConversions customConversions, RelationalManagedTypes jdbcManagedTypes) {
        return JdbcConfiguration.createMappingContext(jdbcManagedTypes, customConversions, namingStrategy.orElse(null));
    }

    @Bean
    public IdGeneratingEntityCallback idGeneratingBeforeSaveCallback(JdbcMappingContext mappingContext, NamedParameterJdbcOperations operations, JdbcDialect dialect) {
        return new IdGeneratingEntityCallback((MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, dialect, operations);
    }

    @Bean
    public JdbcConverter jdbcConverter(JdbcMappingContext mappingContext, NamedParameterJdbcOperations operations, @Lazy RelationResolver relationResolver, JdbcCustomConversions conversions, JdbcDialect dialect) {
        return JdbcConfiguration.createConverter(mappingContext, operations, relationResolver, conversions, dialect);
    }

    @Bean
    public JdbcCustomConversions jdbcCustomConversions() {
        JdbcDialect dialect = (JdbcDialect)this.applicationContext.getBean(JdbcDialect.class);
        return JdbcConfiguration.createCustomConversions(dialect, this.userConverters());
    }

    protected List<?> userConverters() {
        return Collections.emptyList();
    }

    @Bean
    public JdbcAggregateTemplate jdbcAggregateTemplate(ApplicationContext applicationContext, JdbcMappingContext mappingContext, JdbcConverter converter, DataAccessStrategy dataAccessStrategy) {
        return new JdbcAggregateTemplate(applicationContext, (RelationalMappingContext)mappingContext, converter, dataAccessStrategy);
    }

    @Bean
    public DataAccessStrategy dataAccessStrategyBean(NamedParameterJdbcOperations operations, JdbcConverter jdbcConverter, JdbcMappingContext context, JdbcDialect dialect) {
        return JdbcConfiguration.createDataAccessStrategy(operations, jdbcConverter, this.queryMappingConfiguration, dialect);
    }

    @Bean
    public JdbcDialect jdbcDialect(NamedParameterJdbcOperations operations) {
        return DialectResolver.getDialect(operations.getJdbcOperations());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setQueryMappingConfiguration(Optional<QueryMappingConfiguration> queryMappingConfiguration) throws BeansException {
        this.queryMappingConfiguration = queryMappingConfiguration.orElse(QueryMappingConfiguration.EMPTY);
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            initialEntitySet.addAll(this.scanForEntities(basePackage));
        }
        return initialEntitySet;
    }

    protected Set<Class<?>> scanForEntities(String basePackage) {
        return JdbcConfiguration.scanForEntities(basePackage);
    }
}

