/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.callback;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.comparator.Comparators;

class EntityCallbackDiscoverer {
    private final CallbackRetriever defaultRetriever = new CallbackRetriever();
    private final Map<CallbackCacheKey, CallbackRetriever> retrieverCache = new ConcurrentHashMap<CallbackCacheKey, CallbackRetriever>(64);
    private final Map<Class<?>, ResolvableType> entityTypeCache = new ConcurrentReferenceHashMap(64);
    @Nullable
    private ClassLoader beanClassLoader;
    @Nullable
    private BeanFactory beanFactory;
    private Object retrievalMutex = this.defaultRetriever;

    EntityCallbackDiscoverer() {
    }

    EntityCallbackDiscoverer(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntityCallback(EntityCallback<?> callback) {
        Assert.notNull(callback, (String)"Callback must not be null");
        Object object = this.retrievalMutex;
        synchronized (object) {
            Object singletonTarget = AopProxyUtils.getSingletonTarget(callback);
            if (singletonTarget instanceof EntityCallback) {
                this.defaultRetriever.entityCallbacks.remove(singletonTarget);
            }
            this.defaultRetriever.entityCallbacks.add(callback);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntityCallback(EntityCallback<?> callback) {
        Object object = this.retrievalMutex;
        synchronized (object) {
            this.defaultRetriever.entityCallbacks.remove(callback);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends S, S> Collection<EntityCallback<S>> getEntityCallbacks(Class<T> entity, ResolvableType callbackType) {
        Class<T> sourceType = entity;
        CallbackCacheKey cacheKey = new CallbackCacheKey(callbackType, sourceType);
        CallbackRetriever retriever = this.retrieverCache.get(cacheKey);
        if (retriever != null) {
            return retriever.getEntityCallbacks();
        }
        if (this.beanClassLoader == null || ClassUtils.isCacheSafe(entity.getClass(), (ClassLoader)this.beanClassLoader) && (sourceType == null || ClassUtils.isCacheSafe(sourceType, (ClassLoader)this.beanClassLoader))) {
            Object object = this.retrievalMutex;
            synchronized (object) {
                retriever = this.retrieverCache.get(cacheKey);
                if (retriever != null) {
                    return retriever.getEntityCallbacks();
                }
                retriever = new CallbackRetriever();
                Collection<EntityCallback<S>> callbacks = this.retrieveEntityCallbacks(ResolvableType.forClass(sourceType), callbackType, retriever);
                this.retrieverCache.put(cacheKey, retriever);
                return callbacks;
            }
        }
        return this.retrieveEntityCallbacks(callbackType, callbackType, null);
    }

    @Nullable
    ResolvableType resolveDeclaredEntityType(Class<?> callbackType) {
        ResolvableType eventType = this.entityTypeCache.get(callbackType);
        if (eventType == null) {
            eventType = ResolvableType.forClass(callbackType).as(EntityCallback.class).getGeneric(new int[0]);
            this.entityTypeCache.put(callbackType, eventType);
        }
        return eventType != ResolvableType.NONE ? eventType : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<EntityCallback<?>> retrieveEntityCallbacks(ResolvableType entityType, ResolvableType callbackType, @Nullable CallbackRetriever retriever) {
        LinkedHashSet callbacks;
        ArrayList allCallbacks = new ArrayList();
        Iterator iterator = this.retrievalMutex;
        synchronized (iterator) {
            callbacks = new LinkedHashSet(this.defaultRetriever.entityCallbacks);
        }
        for (EntityCallback entityCallback : callbacks) {
            EntityCallback entityCallback2;
            if (!EntityCallbackDiscoverer.supportsEvent(entityCallback, entityType, callbackType)) continue;
            if (entityCallback instanceof EntityCallbackAdapter) {
                EntityCallbackAdapter adapter = (EntityCallbackAdapter)entityCallback;
                v0 = adapter.delegate();
            } else {
                v0 = entityCallback2 = entityCallback;
            }
            if (retriever != null) {
                retriever.getEntityCallbacks().add(entityCallback2);
            }
            allCallbacks.add(entityCallback2);
        }
        AnnotationAwareOrderComparator.sort(allCallbacks);
        if (retriever != null) {
            retriever.entityCallbacks.clear();
            retriever.entityCallbacks.addAll(allCallbacks);
        }
        return allCallbacks;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            if (this.beanClassLoader == null) {
                this.beanClassLoader = cbf.getBeanClassLoader();
            }
            this.retrievalMutex = cbf.getSingletonMutex();
        }
        this.defaultRetriever.discoverEntityCallbacks(beanFactory);
        this.retrieverCache.clear();
    }

    @Nullable
    static Method lookupCallbackMethod(Class<?> callbackType, Class<?> entityType, Object[] args) {
        ArrayList methods = new ArrayList(1);
        ReflectionUtils.doWithMethods(callbackType, methods::add, method -> {
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != args.length + 1 || method.isBridge() || ReflectionUtils.isObjectMethod((Method)method)) {
                return false;
            }
            return ClassUtils.isAssignable(method.getParameterTypes()[0], (Class)entityType);
        });
        if (methods.size() == 1) {
            return (Method)methods.iterator().next();
        }
        throw new IllegalStateException("%s does not define a callback method accepting %s and %s additional arguments".formatted(ClassUtils.getShortName(callbackType), ClassUtils.getShortName(entityType), args.length));
    }

    static <T> BiFunction<EntityCallback<T>, T, Object> computeCallbackInvokerFunction(EntityCallback<T> callback, Method callbackMethod, Object[] args) {
        return (entityCallback, entity) -> {
            Object[] invocationArgs = new Object[args.length + 1];
            invocationArgs[0] = entity;
            if (args.length > 0) {
                System.arraycopy(args, 0, invocationArgs, 1, args.length);
            }
            return ReflectionUtils.invokeMethod((Method)callbackMethod, (Object)callback, (Object[])invocationArgs);
        };
    }

    static boolean supportsEvent(ResolvableType callbackType, ResolvableType entityType) {
        return callbackType.as(EntityCallback.class).getGeneric(new int[]{0}).isAssignableFrom(entityType);
    }

    static boolean supportsEvent(EntityCallback<?> callback, ResolvableType entityType, ResolvableType callbackType) {
        boolean bl;
        if (callback instanceof EntityCallbackAdapter) {
            EntityCallbackAdapter provider = (EntityCallbackAdapter)callback;
            bl = provider.supports(callbackType, entityType);
        } else {
            bl = callbackType.isInstance(callback) && EntityCallbackDiscoverer.supportsEvent(ResolvableType.forInstance(callback), entityType);
        }
        return bl;
    }

    private static class CallbackRetriever {
        private final Set<EntityCallback<?>> entityCallbacks = new LinkedHashSet();

        private CallbackRetriever() {
        }

        Collection<EntityCallback<?>> getEntityCallbacks() {
            return this.entityCallbacks;
        }

        void discoverEntityCallbacks(BeanFactory beanFactory) {
            block6: {
                block5: {
                    if (!(beanFactory instanceof ListableBeanFactory)) break block5;
                    if (beanFactory instanceof BeanDefinitionRegistry) break block6;
                }
                beanFactory.getBeanProvider(EntityCallback.class).stream().forEach(this.entityCallbacks::add);
                return;
            }
            ListableBeanFactory bf = (ListableBeanFactory)((BeanDefinitionRegistry)beanFactory);
            for (String beanName : bf.getBeanNamesForType(EntityCallback.class)) {
                EntityCallback bean = (EntityCallback)EntityCallback.class.cast(bf.getBean(beanName));
                ResolvableType type = ResolvableType.forClass(EntityCallback.class, bean.getClass());
                ResolvableType entityType = type.getGeneric(new int[]{0});
                if (entityType.resolve() != null) {
                    this.entityCallbacks.add(bean);
                    continue;
                }
                BeanDefinition definition = ((BeanDefinitionRegistry)bf).getBeanDefinition(beanName);
                this.entityCallbacks.add(new EntityCallbackAdapter(bean, definition.getResolvableType()));
            }
        }
    }

    private record CallbackCacheKey(ResolvableType callbackType, @Nullable Class<?> entityType) implements Comparable<CallbackCacheKey>
    {
        @Override
        public int compareTo(CallbackCacheKey other) {
            return Comparators.nullsHigh().thenComparing(it -> this.callbackType.toString()).thenComparing(it -> this.entityType.getName()).compare(this, other);
        }
    }

    private record EntityCallbackAdapter<T>(EntityCallback<T> delegate, ResolvableType type) implements EntityCallback<T>
    {
        boolean supports(ResolvableType callbackType, ResolvableType entityType) {
            return callbackType.isInstance(this.delegate) && EntityCallbackDiscoverer.supportsEvent(this.type, entityType);
        }
    }
}

