/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ClassTypeInformation<S>
extends TypeDiscoverer<S> {
    public static final ClassTypeInformation<Collection> COLLECTION = new ClassTypeInformation<Collection>(Collection.class);
    public static final ClassTypeInformation<List> LIST = new ClassTypeInformation<List>(List.class);
    public static final ClassTypeInformation<Set> SET = new ClassTypeInformation<Set>(Set.class);
    public static final ClassTypeInformation<Map> MAP = new ClassTypeInformation<Map>(Map.class);
    public static final ClassTypeInformation<Object> OBJECT = new ClassTypeInformation<Object>(Object.class);
    private static final Map<Class<?>, Reference<ClassTypeInformation<?>>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Class<S> type;

    public static <S> ClassTypeInformation<S> from(Class<S> type) {
        ClassTypeInformation<?> cachedTypeInfo;
        Assert.notNull(type, (String)"Type must not be null!");
        Reference<ClassTypeInformation<?>> cachedReference = CACHE.get(type);
        ClassTypeInformation<?> classTypeInformation = cachedTypeInfo = cachedReference == null ? null : cachedReference.get();
        if (cachedTypeInfo != null) {
            return cachedTypeInfo;
        }
        ClassTypeInformation<S> result = new ClassTypeInformation<S>(type);
        CACHE.put(type, new WeakReference<ClassTypeInformation<S>>(result));
        return result;
    }

    public static <S> TypeInformation<S> fromReturnTypeOf(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return new ClassTypeInformation(method.getDeclaringClass()).createInfo(method.getGenericReturnType());
    }

    ClassTypeInformation(Class<S> type) {
        this(type, (Map<TypeVariable, Type>)GenericTypeResolver.getTypeVariableMap(type));
    }

    ClassTypeInformation(Class<S> type, Map<TypeVariable, Type> typeVariableMap) {
        super(ClassUtils.getUserClass(type), typeVariableMap);
        this.type = type;
    }

    @Override
    public Class<S> getType() {
        return this.type;
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return this;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return this.getType().isAssignableFrom(target.getType());
    }

    public String toString() {
        return this.type.getName();
    }

    static {
        for (ClassTypeInformation info : Arrays.asList(COLLECTION, LIST, SET, MAP, OBJECT)) {
            CACHE.put(info.getType(), new WeakReference<ClassTypeInformation>(info));
        }
    }
}

