/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MessagingAssertThatThen;
import org.springframework.cloud.contract.verifier.builder.MessagingBodyThen;
import org.springframework.cloud.contract.verifier.builder.MessagingHeadersThen;
import org.springframework.cloud.contract.verifier.builder.MessagingReceiveMessageThen;
import org.springframework.cloud.contract.verifier.builder.MessagingSpockNoMessageThen;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MessagingWithBodyThen
implements Then,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final ComparisonBuilder comparisonBuilder;
    private final List<Then> thens = new LinkedList<Then>();

    MessagingWithBodyThen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.comparisonBuilder = comparisonBuilder;
        this.thens.addAll(Arrays.asList(new MessagingSpockNoMessageThen(this.blockBuilder, generatedClassMetaData), new MessagingReceiveMessageThen(this.blockBuilder, generatedClassMetaData, this.comparisonBuilder), new MessagingHeadersThen(this.blockBuilder, generatedClassMetaData, this.comparisonBuilder), new MessagingBodyThen(this.blockBuilder, generatedClassMetaData, comparisonBuilder), new MessagingAssertThatThen(this.blockBuilder)));
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "then:");
        this.bodyBlock(this.blockBuilder, this.thens, singleContractMetadata);
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isMessaging() && singleContractMetadata.getContract().getOutputMessage() != null;
    }
}

