/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.maven.ClassPath;
import org.springframework.boot.maven.SystemPropertyFormatter;
import org.springframework.util.StringUtils;

final class CommandLineBuilder {
    private final List<String> options = new ArrayList<String>();
    private final List<URL> classpathElements = new ArrayList<URL>();
    private final String mainClass;
    private final List<String> arguments = new ArrayList<String>();

    private CommandLineBuilder(String mainClass) {
        this.mainClass = mainClass;
    }

    static CommandLineBuilder forMainClass(String mainClass) {
        return new CommandLineBuilder(mainClass);
    }

    CommandLineBuilder withJvmArguments(String ... jvmArguments) {
        if (jvmArguments != null) {
            this.options.addAll(Arrays.stream(jvmArguments).filter(Objects::nonNull).toList());
        }
        return this;
    }

    CommandLineBuilder withSystemProperties(Map<String, String> systemProperties) {
        if (systemProperties != null) {
            for (Map.Entry<String, String> systemProperty : systemProperties.entrySet()) {
                String option = SystemPropertyFormatter.format(systemProperty.getKey(), systemProperty.getValue());
                if (!StringUtils.hasText((String)option)) continue;
                this.options.add(option);
            }
        }
        return this;
    }

    CommandLineBuilder withClasspath(URL ... elements) {
        this.classpathElements.addAll(Arrays.asList(elements));
        return this;
    }

    CommandLineBuilder withArguments(String ... arguments) {
        if (arguments != null) {
            this.arguments.addAll(Arrays.stream(arguments).filter(Objects::nonNull).toList());
        }
        return this;
    }

    List<String> build() {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (!this.options.isEmpty()) {
            commandLine.addAll(this.options);
        }
        commandLine.addAll(ClassPath.of(this.classpathElements).args(true));
        commandLine.add(this.mainClass);
        if (!this.arguments.isEmpty()) {
            commandLine.addAll(this.arguments);
        }
        return commandLine;
    }
}

