/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.springframework.boot.configurationprocessor.MetadataCollector;
import org.springframework.boot.configurationprocessor.MetadataStore;
import org.springframework.boot.configurationprocessor.TypeElementMembers;
import org.springframework.boot.configurationprocessor.TypeExcludeFilter;
import org.springframework.boot.configurationprocessor.TypeUtils;
import org.springframework.boot.configurationprocessor.fieldvalues.FieldValuesParser;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.JavaCompilerFieldValuesParser;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.InvalidConfigurationMetadataException;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

@SupportedAnnotationTypes(value={"*"})
public class ConfigurationMetadataAnnotationProcessor
extends AbstractProcessor {
    static final String ADDITIONAL_METADATA_LOCATIONS_OPTION = "org.springframework.boot.configurationprocessor.additionalMetadataLocations";
    static final String CONFIGURATION_PROPERTIES_ANNOTATION = "org.springframework.boot.context.properties.ConfigurationProperties";
    static final String NESTED_CONFIGURATION_PROPERTY_ANNOTATION = "org.springframework.boot.context.properties.NestedConfigurationProperty";
    static final String DEPRECATED_CONFIGURATION_PROPERTY_ANNOTATION = "org.springframework.boot.context.properties.DeprecatedConfigurationProperty";
    static final String ENDPOINT_ANNOTATION = "org.springframework.boot.actuate.endpoint.annotation.Endpoint";
    static final String READ_OPERATION_ANNOTATION = "org.springframework.boot.actuate.endpoint.annotation.ReadOperation";
    static final String NULLABLE_ANNOTATION = "org.springframework.lang.Nullable";
    static final String LOMBOK_DATA_ANNOTATION = "lombok.Data";
    static final String LOMBOK_GETTER_ANNOTATION = "lombok.Getter";
    static final String LOMBOK_SETTER_ANNOTATION = "lombok.Setter";
    private static final Set<String> SUPPORTED_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.springframework.boot.configurationprocessor.additionalMetadataLocations")));
    private MetadataStore metadataStore;
    private MetadataCollector metadataCollector;
    private TypeUtils typeUtils;
    private FieldValuesParser fieldValuesParser;
    private TypeExcludeFilter typeExcludeFilter = new TypeExcludeFilter();

    protected String configurationPropertiesAnnotation() {
        return CONFIGURATION_PROPERTIES_ANNOTATION;
    }

    protected String nestedConfigurationPropertyAnnotation() {
        return NESTED_CONFIGURATION_PROPERTY_ANNOTATION;
    }

    protected String deprecatedConfigurationPropertyAnnotation() {
        return DEPRECATED_CONFIGURATION_PROPERTY_ANNOTATION;
    }

    protected String endpointAnnotation() {
        return ENDPOINT_ANNOTATION;
    }

    protected String readOperationAnnotation() {
        return READ_OPERATION_ANNOTATION;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.typeUtils = new TypeUtils(env);
        this.metadataStore = new MetadataStore(env);
        this.metadataCollector = new MetadataCollector(env, this.metadataStore.readMetadata());
        try {
            this.fieldValuesParser = new JavaCompilerFieldValuesParser(env);
        }
        catch (Throwable ex) {
            this.fieldValuesParser = FieldValuesParser.NONE;
            this.logWarning("Field value processing of @ConfigurationProperty meta-data is not supported");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement endpointType;
        this.metadataCollector.processing(roundEnv);
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationType = elementUtils.getTypeElement(this.configurationPropertiesAnnotation());
        if (annotationType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                this.processElement(element);
            }
        }
        if ((endpointType = elementUtils.getTypeElement(this.endpointAnnotation())) != null) {
            this.getElementsAnnotatedOrMetaAnnotatedWith(roundEnv, endpointType).forEach(this::processEndpoint);
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeMetaData();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to write metadata", exception);
            }
        }
        return false;
    }

    private Map<Element, List<Element>> getElementsAnnotatedOrMetaAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotation) {
        DeclaredType annotationType = (DeclaredType)annotation.asType();
        LinkedHashMap<Element, List<Element>> result = new LinkedHashMap<Element, List<Element>>();
        for (Element element : roundEnv.getRootElements()) {
            LinkedList<Element> stack = new LinkedList<Element>();
            stack.push(element);
            this.collectElementsAnnotatedOrMetaAnnotatedWith(annotationType, stack);
            stack.removeFirst();
            if (stack.isEmpty()) continue;
            result.put(element, Collections.unmodifiableList(stack));
        }
        return result;
    }

    private boolean collectElementsAnnotatedOrMetaAnnotatedWith(DeclaredType annotationType, LinkedList<Element> stack) {
        Element element = stack.peekLast();
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(element)) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (stack.contains(annotationElement)) continue;
            stack.addLast(annotationElement);
            if (annotationElement.equals(annotationType.asElement())) {
                return true;
            }
            if (this.collectElementsAnnotatedOrMetaAnnotatedWith(annotationType, stack)) continue;
            stack.removeLast();
        }
        return false;
    }

    private void processElement(Element element) {
        try {
            AnnotationMirror annotation = this.getAnnotation(element, this.configurationPropertiesAnnotation());
            if (annotation != null) {
                String prefix = this.getPrefix(annotation);
                if (element instanceof TypeElement) {
                    this.processAnnotatedTypeElement(prefix, (TypeElement)element);
                } else if (element instanceof ExecutableElement) {
                    this.processExecutableElement(prefix, (ExecutableElement)element);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private void processAnnotatedTypeElement(String prefix, TypeElement element) {
        String type = this.typeUtils.getQualifiedName(element);
        this.metadataCollector.add(ItemMetadata.newGroup(prefix, type, type, null));
        this.processTypeElement(prefix, element, null);
    }

    private void processExecutableElement(String prefix, ExecutableElement element) {
        Element returns;
        if (element.getModifiers().contains((Object)Modifier.PUBLIC) && TypeKind.VOID != element.getReturnType().getKind() && (returns = this.processingEnv.getTypeUtils().asElement(element.getReturnType())) instanceof TypeElement) {
            ItemMetadata group = ItemMetadata.newGroup(prefix, this.typeUtils.getQualifiedName(returns), this.typeUtils.getQualifiedName(element.getEnclosingElement()), element.toString());
            if (this.metadataCollector.hasSimilarGroup(group)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate `@ConfigurationProperties` definition for prefix '" + prefix + "'", element);
            } else {
                this.metadataCollector.add(group);
                this.processTypeElement(prefix, (TypeElement)returns, element);
            }
        }
    }

    private void processTypeElement(String prefix, TypeElement element, ExecutableElement source) {
        TypeElementMembers members = new TypeElementMembers(this.processingEnv, this.fieldValuesParser, element);
        Map<String, Object> fieldValues = members.getFieldValues();
        this.processSimpleTypes(prefix, element, source, members, fieldValues);
        this.processSimpleLombokTypes(prefix, element, source, members, fieldValues);
        this.processNestedTypes(prefix, element, source, members);
        this.processNestedLombokTypes(prefix, element, source, members);
    }

    private void processSimpleTypes(String prefix, TypeElement element, ExecutableElement source, TypeElementMembers members, Map<String, Object> fieldValues) {
        members.getPublicGetters().forEach((name, getter) -> {
            TypeMirror returnType = getter.getReturnType();
            ExecutableElement setter = members.getPublicSetter((String)name, returnType);
            VariableElement field = members.getFields().get(name);
            Element returnTypeElement = this.processingEnv.getTypeUtils().asElement(returnType);
            boolean isExcluded = this.typeExcludeFilter.isExcluded(returnType);
            boolean isNested = this.isNested(returnTypeElement, field, element);
            boolean isCollection = this.typeUtils.isCollectionOrMap(returnType);
            if (!(isExcluded || isNested || setter == null && !isCollection)) {
                String dataType = this.typeUtils.getType(returnType);
                String sourceType = this.typeUtils.getQualifiedName(element);
                String description = this.typeUtils.getJavaDoc(field);
                Object defaultValue = fieldValues.get(name);
                boolean deprecated = this.isDeprecated((Element)getter) || this.isDeprecated(setter) || this.isDeprecated(source);
                this.metadataCollector.add(ItemMetadata.newProperty(prefix, name, dataType, sourceType, null, description, defaultValue, deprecated ? this.getItemDeprecation((ExecutableElement)getter) : null));
            }
        });
    }

    private ItemDeprecation getItemDeprecation(ExecutableElement getter) {
        AnnotationMirror annotation = this.getAnnotation(getter, this.deprecatedConfigurationPropertyAnnotation());
        String reason = null;
        String replacement = null;
        if (annotation != null) {
            Map<String, Object> elementValues = this.getAnnotationElementValues(annotation);
            reason = (String)elementValues.get("reason");
            replacement = (String)elementValues.get("replacement");
        }
        return new ItemDeprecation("".equals(reason) ? null : reason, "".equals(replacement) ? null : replacement);
    }

    private void processSimpleLombokTypes(String prefix, TypeElement element, ExecutableElement source, TypeElementMembers members, Map<String, Object> fieldValues) {
        members.getFields().forEach((name, field) -> {
            if (!this.isLombokField((VariableElement)field, element)) {
                return;
            }
            TypeMirror returnType = field.asType();
            Element returnTypeElement = this.processingEnv.getTypeUtils().asElement(returnType);
            boolean isExcluded = this.typeExcludeFilter.isExcluded(returnType);
            boolean isNested = this.isNested(returnTypeElement, (VariableElement)field, element);
            boolean isCollection = this.typeUtils.isCollectionOrMap(returnType);
            boolean hasSetter = this.hasLombokSetter((VariableElement)field, element);
            if (!isExcluded && !isNested && (hasSetter || isCollection)) {
                String dataType = this.typeUtils.getType(returnType);
                String sourceType = this.typeUtils.getQualifiedName(element);
                String description = this.typeUtils.getJavaDoc((Element)field);
                Object defaultValue = fieldValues.get(name);
                boolean deprecated = this.isDeprecated((Element)field) || this.isDeprecated(source);
                this.metadataCollector.add(ItemMetadata.newProperty(prefix, name, dataType, sourceType, null, description, defaultValue, deprecated ? new ItemDeprecation() : null));
            }
        });
    }

    private void processNestedTypes(String prefix, TypeElement element, ExecutableElement source, TypeElementMembers members) {
        members.getPublicGetters().forEach((name, getter) -> {
            VariableElement field = members.getFields().get(name);
            this.processNestedType(prefix, element, source, (String)name, (ExecutableElement)getter, field, getter.getReturnType());
        });
    }

    private void processNestedLombokTypes(String prefix, TypeElement element, ExecutableElement source, TypeElementMembers members) {
        members.getFields().forEach((name, field) -> {
            if (this.isLombokField((VariableElement)field, element)) {
                ExecutableElement getter = members.getPublicGetter((String)name, field.asType());
                this.processNestedType(prefix, element, source, (String)name, getter, (VariableElement)field, field.asType());
            }
        });
    }

    private boolean isLombokField(VariableElement field, TypeElement element) {
        return this.hasAnnotation(field, LOMBOK_GETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_GETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_DATA_ANNOTATION);
    }

    private boolean hasLombokSetter(VariableElement field, TypeElement element) {
        return !field.getModifiers().contains((Object)Modifier.FINAL) && (this.hasAnnotation(field, LOMBOK_SETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_SETTER_ANNOTATION) || this.hasAnnotation(element, LOMBOK_DATA_ANNOTATION));
    }

    private void processNestedType(String prefix, TypeElement element, ExecutableElement source, String name, ExecutableElement getter, VariableElement field, TypeMirror returnType) {
        Element returnElement = this.processingEnv.getTypeUtils().asElement(returnType);
        boolean isNested = this.isNested(returnElement, field, element);
        AnnotationMirror annotation = this.getAnnotation(getter, this.configurationPropertiesAnnotation());
        if (returnElement instanceof TypeElement && annotation == null && isNested) {
            String nestedPrefix = ConfigurationMetadata.nestedPrefix(prefix, name);
            this.metadataCollector.add(ItemMetadata.newGroup(nestedPrefix, this.typeUtils.getQualifiedName(returnElement), this.typeUtils.getQualifiedName(element), getter != null ? getter.toString() : null));
            this.processTypeElement(nestedPrefix, (TypeElement)returnElement, source);
        }
    }

    private void processEndpoint(Element element, List<Element> annotations) {
        try {
            String annotationName = this.typeUtils.getQualifiedName(annotations.get(0));
            AnnotationMirror annotation = this.getAnnotation(element, annotationName);
            if (element instanceof TypeElement) {
                this.processEndpoint(annotation, (TypeElement)element);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private void processEndpoint(AnnotationMirror annotation, TypeElement element) {
        Map<String, Object> elementValues = this.getAnnotationElementValues(annotation);
        String endpointId = (String)elementValues.get("id");
        if (endpointId == null || "".equals(endpointId)) {
            return;
        }
        String endpointKey = ItemMetadata.newItemMetadataPrefix("management.endpoint.", endpointId);
        Boolean enabledByDefault = (Boolean)elementValues.get("enableByDefault");
        String type = this.typeUtils.getQualifiedName(element);
        this.metadataCollector.add(ItemMetadata.newGroup(endpointKey, type, type, null));
        this.metadataCollector.add(ItemMetadata.newProperty(endpointKey, "enabled", Boolean.class.getName(), type, null, String.format("Whether to enable the %s endpoint.", endpointId), enabledByDefault != null ? enabledByDefault : true, null));
        if (this.hasMainReadOperation(element)) {
            this.metadataCollector.add(ItemMetadata.newProperty(endpointKey, "cache.time-to-live", Duration.class.getName(), type, null, "Maximum time that a response can be cached.", "0ms", null));
        }
    }

    private boolean hasMainReadOperation(TypeElement element) {
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (!this.hasAnnotation(method, this.readOperationAnnotation()) || TypeKind.VOID == method.getReturnType().getKind() || !this.hasNoOrOptionalParameters(method)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNoOrOptionalParameters(ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            if (this.hasAnnotation(variableElement, NULLABLE_ANNOTATION)) continue;
            return false;
        }
        return true;
    }

    private boolean isNested(Element returnType, VariableElement field, TypeElement element) {
        if (this.hasAnnotation(field, this.nestedConfigurationPropertyAnnotation())) {
            return true;
        }
        if (this.isCyclePresent(returnType, element)) {
            return false;
        }
        return this.isParentTheSame(returnType, element) && returnType.getKind() != ElementKind.ENUM;
    }

    private boolean isCyclePresent(Element returnType, Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return false;
        }
        if (element.getEnclosingElement().equals(returnType)) {
            return true;
        }
        return this.isCyclePresent(returnType, element.getEnclosingElement());
    }

    private boolean isParentTheSame(Element returnType, TypeElement element) {
        if (returnType == null || element == null) {
            return false;
        }
        return this.getTopLevelType(returnType).equals(this.getTopLevelType(element));
    }

    private Element getTopLevelType(Element element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return element;
        }
        return this.getTopLevelType(element.getEnclosingElement());
    }

    private boolean isDeprecated(Element element) {
        if (this.isElementDeprecated(element)) {
            return true;
        }
        if (element instanceof VariableElement || element instanceof ExecutableElement) {
            return this.isElementDeprecated(element.getEnclosingElement());
        }
        return false;
    }

    private boolean isElementDeprecated(Element element) {
        return this.hasAnnotation(element, "java.lang.Deprecated") || this.hasAnnotation(element, this.deprecatedConfigurationPropertyAnnotation());
    }

    private boolean hasAnnotation(Element element, String type) {
        return this.getAnnotation(element, type) != null;
    }

    private AnnotationMirror getAnnotation(Element element, String type) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private String getPrefix(AnnotationMirror annotation) {
        Map<String, Object> elementValues = this.getAnnotationElementValues(annotation);
        Object prefix = elementValues.get("prefix");
        if (prefix != null && !"".equals(prefix)) {
            return (String)prefix;
        }
        Object value = elementValues.get("value");
        if (value != null && !"".equals(value)) {
            return (String)value;
        }
        return null;
    }

    private Map<String, Object> getAnnotationElementValues(AnnotationMirror annotation) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        annotation.getElementValues().forEach((name, value) -> values.put(name.getSimpleName().toString(), value.getValue()));
        return values;
    }

    protected ConfigurationMetadata writeMetaData() throws Exception {
        ConfigurationMetadata metadata = this.metadataCollector.getMetadata();
        if (!(metadata = this.mergeAdditionalMetadata(metadata)).getItems().isEmpty()) {
            this.metadataStore.writeMetadata(metadata);
            return metadata;
        }
        return null;
    }

    private ConfigurationMetadata mergeAdditionalMetadata(ConfigurationMetadata metadata) {
        try {
            ConfigurationMetadata merged = new ConfigurationMetadata(metadata);
            merged.merge(this.metadataStore.readAdditionalMetadata());
            return merged;
        }
        catch (FileNotFoundException merged) {
        }
        catch (InvalidConfigurationMetadataException ex) {
            this.log(ex.getKind(), ex.getMessage());
        }
        catch (Exception ex) {
            this.logWarning("Unable to merge additional metadata");
            this.logWarning(this.getStackTrace(ex));
        }
        return metadata;
    }

    private String getStackTrace(Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.toString();
    }

    private void logWarning(String msg) {
        this.log(Diagnostic.Kind.WARNING, msg);
    }

    private void log(Diagnostic.Kind kind, String msg) {
        this.processingEnv.getMessager().printMessage(kind, msg);
    }
}

