/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.sonarsource.scanner.api.internal.OkHttpClientFactory;
import org.sonarsource.scanner.api.internal.cache.Logger;
import org.sonarsource.scanner.api.internal.shaded.commonsio.FileUtils;
import org.sonarsource.scanner.api.internal.shaded.commonsio.IOUtils;
import org.sonarsource.scanner.api.internal.shaded.okhttp.OkHttpClient;
import org.sonarsource.scanner.api.internal.shaded.okhttp.Request;
import org.sonarsource.scanner.api.internal.shaded.okhttp.Response;
import org.sonarsource.scanner.api.internal.shaded.okhttp.ResponseBody;

class ServerConnection {
    private final String baseUrlWithoutTrailingSlash;
    private final String userAgent;
    private final OkHttpClient httpClient;
    private final Logger logger;

    ServerConnection(String baseUrl, String userAgent, Logger logger) {
        this.logger = logger;
        this.baseUrlWithoutTrailingSlash = ServerConnection.removeTrailingSlash(baseUrl);
        this.userAgent = userAgent;
        this.httpClient = OkHttpClientFactory.create();
    }

    private static String removeTrailingSlash(String url) {
        return url.replaceAll("(/)+$", "");
    }

    public static ServerConnection create(Properties props, Logger logger) {
        String serverUrl = props.getProperty("sonar.host.url");
        String userAgent = String.format("%s/%s", props.getProperty("sonarRunner.app"), props.getProperty("sonarRunner.appVersion"));
        return new ServerConnection(serverUrl, userAgent, logger);
    }

    public void downloadFile(String urlPath, File toFile) throws IOException {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format("URL path must start with slash: %s", urlPath));
        }
        String url = this.baseUrlWithoutTrailingSlash + urlPath;
        this.logger.debug(String.format("Download %s to %s", url, toFile.getAbsolutePath()));
        ResponseBody responseBody = this.callUrl(url);
        try (FileOutputStream fileOutput = new FileOutputStream(toFile);
             InputStream byteStream = responseBody.byteStream();){
            IOUtils.copyLarge(byteStream, fileOutput);
        }
        catch (IOException | RuntimeException e) {
            FileUtils.deleteQuietly(toFile);
            throw e;
        }
    }

    public String downloadString(String urlPath) throws IOException {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format("URL path must start with slash: %s", urlPath));
        }
        String url = this.baseUrlWithoutTrailingSlash + urlPath;
        this.logger.debug(String.format("Download: %s", url));
        ResponseBody responseBody = this.callUrl(url);
        return responseBody.string();
    }

    private ResponseBody callUrl(String url) throws IOException {
        try {
            Request request = new Request.Builder().url(url).addHeader("User-Agent", this.userAgent).get().build();
            Response response = this.httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IllegalStateException(String.format("Status returned by url [%s] is not valid: [%s]", response.request().url(), response.code()));
            }
            return response.body();
        }
        catch (Exception e) {
            this.logger.error(String.format("SonarQube server [%s] can not be reached", this.baseUrlWithoutTrailingSlash));
            throw e;
        }
    }
}

