/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import javax.annotation.Nullable;
import org.sonarsource.scanner.api.internal.BootstrapIndexDownloader;
import org.sonarsource.scanner.api.internal.JarDownloader;
import org.sonarsource.scanner.api.internal.JarExtractor;
import org.sonarsource.scanner.api.internal.ServerConnection;
import org.sonarsource.scanner.api.internal.cache.FileCache;
import org.sonarsource.scanner.api.internal.cache.FileCacheBuilder;
import org.sonarsource.scanner.api.internal.cache.Logger;

class JarDownloaderFactory {
    private final ServerConnection serverConnection;
    private final Logger logger;
    private final String userHome;

    JarDownloaderFactory(ServerConnection conn, Logger logger, @Nullable String userHome) {
        this.serverConnection = conn;
        this.logger = logger;
        this.userHome = userHome;
    }

    JarDownloader create() {
        FileCache fileCache = new FileCacheBuilder(this.logger).setUserHome(this.userHome).build();
        BootstrapIndexDownloader bootstrapIndexDownloader = new BootstrapIndexDownloader(this.serverConnection, this.logger);
        JarDownloader.ScannerFileDownloader scannerFileDownloader = new JarDownloader.ScannerFileDownloader(this.serverConnection);
        JarExtractor jarExtractor = new JarExtractor();
        return new JarDownloader(scannerFileDownloader, bootstrapIndexDownloader, fileCache, jarExtractor, this.logger);
    }
}

