/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.sonarsource.scanner.api.internal.shaded.minimaljson.Json;
import org.sonarsource.scanner.api.internal.shaded.minimaljson.JsonObject;
import org.sonarsource.scanner.api.internal.shaded.minimaljson.JsonValue;

public class Utils {
    private static final String SONARQUBE_SCANNER_PARAMS = "SONARQUBE_SCANNER_PARAMS";

    private Utils() {
    }

    public static Properties loadEnvironmentProperties(Map<String, String> env) {
        String scannerParams = env.get(SONARQUBE_SCANNER_PARAMS);
        Properties props = new Properties();
        if (scannerParams != null) {
            try {
                JsonValue jsonValue = Json.parse(scannerParams);
                JsonObject jsonObject = jsonValue.asObject();
                for (JsonObject.Member member : jsonObject) {
                    String key = member.getName();
                    String value = member.getValue().asString();
                    props.put(key, value);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse JSON in SONARQUBE_SCANNER_PARAMS environment variable", e);
            }
        }
        return props;
    }

    static String join(String[] array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = Arrays.asList(array).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) break;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    static boolean taskRequiresProject(Map<String, String> props) {
        String task = props.get("sonar.task");
        return task == null || "scan".equals(task);
    }

    static void writeProperties(File outputFile, Properties p) {
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            p.store(output, "Generated by sonar-runner");
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to export sonar-runner properties", e);
        }
    }

    public static void deleteQuietly(Path f) {
        try {
            Files.walkFileTree(f, new DeleteQuietlyFileVisitor());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DeleteQuietlyFileVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteQuietlyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            return DeleteQuietlyFileVisitor.deleteAndContinue(file);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return DeleteQuietlyFileVisitor.deleteAndContinue(file);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return DeleteQuietlyFileVisitor.deleteAndContinue(dir);
        }

        private static FileVisitResult deleteAndContinue(Path path) {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

