/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.jpa;

import java.util.Properties;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;

/**
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $m
 */
public class TransactionManagerLookup implements org.hibernate.transaction.TransactionManagerLookup {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(TransactionManagerLookup.class);

    @Override
    public TransactionManager getTransactionManager(Properties properties) throws HibernateException {
        try {
            TransactionManager transactionManager = com.arjuna.ats.jta.TransactionManager.transactionManager();
            return transactionManager;
        } catch (Exception eee) {
            throw new HibernateException("Error getting JBossTM", eee);
        }
    }

    @Override
    public String getUserTransactionName() {
//        String jtaUTJNDIContext = jtaPropertyManager.getJTAEnvironmentBean().getJtaUTJNDIContext();
//        log.debug("jtaUTJNDIContext " + jtaUTJNDIContext);
//        return jtaUTJNDIContext;
        return null;
    }

    @Override
    public Object getTransactionIdentifier(Transaction t) {
        return null;
    }

}
