/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openqa.selenium.ProcessUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.internal.OutputWatcher;

public class SubProcess {
    private final Object lock = new Object();
    private final ProcessBuilder processBuilder;
    private final OutputStream outputStream;
    private ExecutorService executorService;
    private Process currentProcess;
    private Future<?> outputWatcher;

    public SubProcess(ProcessBuilder processBuilder) {
        this(processBuilder, SubProcess.nullOutputStream());
    }

    public SubProcess(ProcessBuilder processBuilder, OutputStream outputStream) {
        this.processBuilder = processBuilder.redirectErrorStream(true);
        this.outputStream = outputStream;
        this.executorService = null;
        this.currentProcess = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning()) {
                try {
                    this.currentProcess = this.processBuilder.start();
                    this.executorService = Executors.newSingleThreadExecutor();
                    this.outputWatcher = this.executorService.submit(new OutputWatcher(this.currentProcess.getInputStream(), this.outputStream));
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exitValue() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentProcess == null) {
                throw new IllegalThreadStateException("Process has not yet launched");
            }
            return this.currentProcess.exitValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentProcess == null) {
                return false;
            }
            try {
                this.exitValue();
                return false;
            }
            catch (IllegalThreadStateException ignored) {
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                this.outputWatcher.cancel(true);
                this.executorService.shutdownNow();
                ProcessUtils.killProcess((Process)this.currentProcess);
            }
        }
    }

    private static OutputStream nullOutputStream() {
        return new OutputStream(){

            public void write(int i) throws IOException {
            }
        };
    }
}

