/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.Wait;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;
import org.openqa.selenium.internal.seleniumemulation.Windows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitForPopup
extends SeleneseCommand<Void> {
    private final Windows windows;

    public WaitForPopup(Windows windows) {
        this.windows = windows;
    }

    @Override
    protected Void handleSeleneseCommand(final WebDriver driver, final String windowID, String timeout) {
        long millis = Long.parseLong(timeout);
        String current = driver.getWindowHandle();
        new Wait(){

            public boolean until() {
                try {
                    if ("_blank".equals(windowID)) {
                        WaitForPopup.this.windows.selectBlankWindow(driver);
                    } else {
                        driver.switchTo().window(windowID);
                    }
                    return !"about:blank".equals(driver.getCurrentUrl());
                }
                catch (SeleniumException seleniumException) {
                    return false;
                }
            }
        }.wait(String.format("Timed out waiting for %s. Waited %s", windowID, timeout), millis);
        driver.switchTo().window(current);
        return null;
    }
}

