/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.collect.Lists;
import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumSelect {
    private final String findOption;
    private final WebDriver driver;
    private final WebElement select;

    public SeleniumSelect(JavascriptLibrary library, ElementFinder finder, WebDriver driver, String locator) {
        this.driver = driver;
        this.findOption = "return (" + library.getSeleniumScript("findOption.js") + ").apply(null, arguments)";
        this.select = finder.findElement(driver, locator);
        if (!"select".equals(this.select.getTagName().toLowerCase())) {
            throw new SeleniumException("Element is not a select element: " + locator);
        }
    }

    public void setSelected(String optionLocator) {
        WebElement option;
        if (this.isMultiple()) {
            for (WebElement opt : this.select.findElements(By.tagName((String)"option"))) {
                if (!opt.isSelected()) continue;
                opt.click();
            }
        }
        if (!(option = this.findOption(optionLocator)).isSelected()) {
            option.click();
        }
    }

    public void addSelection(String optionLocator) {
        this.assertSupportsMultipleSelections();
        WebElement option = this.findOption(optionLocator);
        if (!option.isSelected()) {
            option.click();
        }
    }

    public void removeSelection(String optionLocator) {
        this.assertSupportsMultipleSelections();
        WebElement option = this.findOption(optionLocator);
        if (option.isSelected()) {
            option.click();
        }
    }

    public List<WebElement> getSelectedOptions() {
        ArrayList toReturn = Lists.newArrayList();
        for (WebElement option : this.select.findElements(By.tagName((String)"option"))) {
            if (!option.isSelected()) continue;
            toReturn.add(option);
        }
        return toReturn;
    }

    private WebElement findOption(String optionLocator) {
        return (WebElement)((JavascriptExecutor)this.driver).executeScript(this.findOption, new Object[]{this.select, optionLocator});
    }

    private void assertSupportsMultipleSelections() {
        if (!this.isMultiple()) {
            throw new SeleniumException("You may only add a selection to a select that supports multiple selections");
        }
    }

    private boolean isMultiple() {
        String multipleValue = this.select.getAttribute("multiple");
        boolean multiple = "true".equals(multipleValue) || "multiple".equals(multipleValue);
        return multiple;
    }

    public List<WebElement> getAllOptions() {
        return this.select.findElements(By.tagName((String)"option"));
    }
}

