/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.CompositeAction;
import org.openqa.selenium.interactions.ContextClickAction;
import org.openqa.selenium.interactions.DoubleClickAction;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.MoveMouseAction;
import org.openqa.selenium.interactions.SendKeysAction;

public class ActionChainsGenerator {
    private final WebDriver driver;
    private CompositeAction action;
    private WebElement onElement;

    public ActionChainsGenerator(WebDriver driver) {
        this.driver = driver;
        this.action = new CompositeAction();
    }

    public ActionChainsGenerator onElement(WebElement element) {
        this.onElement = element;
        return this;
    }

    public ActionChainsGenerator keyDown(Keys theKey) {
        return this.keyDown(this.onElement, theKey);
    }

    public ActionChainsGenerator keyDown(WebElement element, Keys theKey) {
        this.action.addAction(new KeyDownAction(this.driver, element, theKey));
        return this;
    }

    public ActionChainsGenerator keyUp(Keys theKey) {
        return this.keyUp(this.onElement, theKey);
    }

    public ActionChainsGenerator keyUp(WebElement element, Keys theKey) {
        this.action.addAction(new KeyUpAction(this.driver, element, theKey));
        return this;
    }

    public ActionChainsGenerator sendKeys(CharSequence ... keysToSend) {
        return this.sendKeys(this.onElement, keysToSend);
    }

    public ActionChainsGenerator sendKeys(WebElement element, CharSequence ... keysToSend) {
        this.action.addAction(new SendKeysAction(this.driver, element, keysToSend));
        return this;
    }

    public Action build() {
        CompositeAction toReturn = this.action;
        this.action = null;
        return toReturn;
    }

    public ActionChainsGenerator clickAndHold(WebElement onElement) {
        this.action.addAction(new ClickAndHoldAction(this.driver, onElement));
        return this;
    }

    public ActionChainsGenerator release(WebElement onElement) {
        this.action.addAction(new ButtonReleaseAction(this.driver, onElement));
        return this;
    }

    public ActionChainsGenerator click(WebElement onElement) {
        this.action.addAction(new ClickAction(this.driver, onElement));
        return this;
    }

    public ActionChainsGenerator doubleClick(WebElement onElement) {
        this.action.addAction(new DoubleClickAction(this.driver, onElement));
        return this;
    }

    public ActionChainsGenerator moveToElement(WebElement toElement) {
        this.action.addAction(new MoveMouseAction(this.driver, toElement));
        return this;
    }

    public ActionChainsGenerator contextClick(WebElement onElement) {
        this.action.addAction(new ContextClickAction(this.driver, onElement));
        return this;
    }
}

