/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeDriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";
    private final URL url;
    private final ReentrantLock lock = new ReentrantLock();
    private CommandLine process = null;
    private final String executable;
    private final ImmutableList<String> args;
    private final ImmutableMap<String, String> environment;

    private ChromeDriverService(File executable, int port, ImmutableMap<String, String> environment, File logFile) throws IOException {
        this.executable = executable.getCanonicalPath();
        this.args = this.buildArgsFrom(port, logFile);
        this.url = new URL(String.format("http://localhost:%d", port));
        this.environment = environment;
    }

    private ImmutableList<String> buildArgsFrom(int port, File logFile) {
        ImmutableList.Builder argsBuilder = ImmutableList.builder();
        argsBuilder.add((Object)String.format("--port=%d", port));
        if (logFile != null) {
            argsBuilder.add((Object)String.format("--log-path=%s", logFile.getAbsolutePath()));
        }
        return argsBuilder.build();
    }

    public URL getUrl() {
        return this.url;
    }

    public static ChromeDriverService createDefaultService() {
        String defaultPath = CommandLine.findExecutable((String)"chromedriver");
        String exePath = System.getProperty(CHROME_DRIVER_EXE_PROPERTY, defaultPath);
        Preconditions.checkState((exePath != null ? 1 : 0) != 0, (String)"The path to the chromedriver executable must be set by the %s system property; for more information, see http://code.google.com/p/selenium/wiki/ChromeDriver. The latest version can be downloaded from http://code.google.com/p/chromedriver/downloads/list", (Object[])new Object[]{CHROME_DRIVER_EXE_PROPERTY});
        File exe = new File(exePath);
        Preconditions.checkState((boolean)exe.exists(), (String)"The %s system property defined chromedriver executable does not exist: %s", (Object[])new Object[]{CHROME_DRIVER_EXE_PROPERTY, exe.getAbsolutePath()});
        Preconditions.checkState((!exe.isDirectory() ? 1 : 0) != 0, (String)"The %s system property defined chromedriver executable is a directory: %s", (Object[])new Object[]{CHROME_DRIVER_EXE_PROPERTY, exe.getAbsolutePath()});
        return new Builder().usingChromeDriverExecutable(exe).usingAnyFreePort().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null) {
                boolean bl = false;
                return bl;
            }
            this.process.destroy();
            boolean bl = false;
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            this.process = new CommandLine(this.executable, (String[])this.args.toArray((Object[])new String[0]));
            this.process.setEnvironmentVariables(this.environment);
            this.process.copyOutputTo((OutputStream)System.err);
            this.process.executeAsync();
            URL status = new URL(this.url.toString() + "/status");
            URL healthz = new URL(this.url.toString() + "/healthz");
            new UrlChecker().waitUntilAvailable(20L, TimeUnit.SECONDS, new URL[]{status, healthz});
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for ChromeDriver server to start.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.process == null) {
                return;
            }
            URL killUrl = new URL(this.url.toString() + "/shutdown");
            new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
            this.process.destroy();
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for ChromeDriver server to shutdown.", (Throwable)e);
        }
        finally {
            this.process = null;
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;

        public Builder usingChromeDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            Preconditions.checkArgument((boolean)file.exists(), (String)"Specified chromedriver executable does not exist: %s", (Object[])new Object[]{file.getPath()});
            Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0, (String)"Specified chromedriver executable is a directory: %s", (Object[])new Object[]{file.getPath()});
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public ChromeDriverService build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            Preconditions.checkState((this.exe != null ? 1 : 0) != 0, (Object)"Path to the chromedriver executable not specified");
            try {
                return new ChromeDriverService(this.exe, this.port, this.environment, this.logFile);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

