/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import org.sejda.core.writer.model.ImageWriter;
import org.sejda.core.writer.model.ImageWriterAbstractFactory;
import org.sejda.core.writer.xmlgraphics.ImageWriterBuildersRegistry;
import org.sejda.core.writer.xmlgraphics.JpegImageWriterAdapter;
import org.sejda.core.writer.xmlgraphics.MultipleOutputTiffImageWriterAdapter;
import org.sejda.core.writer.xmlgraphics.SingleOutputTiffImageWriterAdapter;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;
import org.sejda.model.parameter.image.PdfToJpegParameters;
import org.sejda.model.parameter.image.PdfToMultipleTiffParameters;
import org.sejda.model.parameter.image.PdfToSingleTiffParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageWriterFactory
implements ImageWriterAbstractFactory {
    private static final ImageWriterBuildersRegistry BUILDERS_REGISTRY = new ImageWriterBuildersRegistry();

    @Override
    public <T extends AbstractPdfToImageParameters> ImageWriter<T> createImageWriter(T params) {
        ImageWriter.ImageWriterBuilder<T> builder = BUILDERS_REGISTRY.getBuilder(params);
        if (builder != null) {
            return builder.build();
        }
        return null;
    }

    static {
        BUILDERS_REGISTRY.addBuilder(PdfToMultipleTiffParameters.class, new MultipleOutputTiffImageWriterAdapter.MultipleOutputTiffImageWriterAdapterBuilder());
        BUILDERS_REGISTRY.addBuilder(PdfToSingleTiffParameters.class, new SingleOutputTiffImageWriterAdapter.SingleOutputTiffImageWriterAdapterBuilder());
        BUILDERS_REGISTRY.addBuilder(PdfToJpegParameters.class, new JpegImageWriterAdapter.JpegImageWriterAdapterBuilder());
    }
}

