/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.python.util.PythonInterpreter;
import org.robotframework.mavenplugin.RobotMojoClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMojoWithLoadedClasspath
extends AbstractMojo {
    private static RobotMojoClassLoader currentMojoLoader;
    private static String ROBOT_ARTIFACT;
    private List<String> classpathElements;
    private String localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadClassPath();
        this.subclassExecute();
    }

    protected abstract void subclassExecute() throws MojoExecutionException, MojoFailureException;

    private void loadClassPath() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpathElements != null) {
            for (String element : this.classpathElements) {
                File elementFile = new File(element);
                try {
                    urls.add(elementFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Classpath loading error: " + element);
                }
            }
        }
        if (urls.size() > 0) {
            this.updateMojoLoader(urls);
            Thread.currentThread().setContextClassLoader(currentMojoLoader);
        }
    }

    protected String getClassPathString() {
        if (this.localRepository == null || this.classpathElements == null) {
            return System.getProperty("java.class.path");
        }
        String result = this.getRobotJar();
        for (String elem : this.classpathElements) {
            result = result + File.pathSeparator + elem;
        }
        return result;
    }

    protected String getRobotJar() {
        File robots = new File(this.localRepository, ROBOT_ARTIFACT);
        String configured = AbstractMojoWithLoadedClasspath.currentVersion();
        return AbstractMojoWithLoadedClasspath.join(File.separator, robots.toString(), configured, "robotframework-" + configured + ".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String currentVersion() {
        PythonInterpreter interp = new PythonInterpreter();
        try {
            interp.exec("from robot import version");
            interp.exec("rf_version = version.VERSION");
            String string = interp.get("rf_version").toString();
            return string;
        }
        finally {
            interp.cleanup();
        }
    }

    protected static String join(String joiner, String ... elements) {
        StringBuilder result = new StringBuilder();
        for (String elem : elements) {
            result.append(elem).append(joiner);
        }
        return result.substring(0, result.length() - joiner.length());
    }

    private void updateMojoLoader(List<URL> urls) {
        if (currentMojoLoader == null) {
            currentMojoLoader = new RobotMojoClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        } else {
            currentMojoLoader.append(urls);
        }
    }

    public File makeAbsolute(File folder, File file) {
        File output = file.isAbsolute() ? file : new File(folder, file.getName());
        return output;
    }

    static {
        ROBOT_ARTIFACT = AbstractMojoWithLoadedClasspath.join(File.separator, "org", "robotframework", "robotframework");
    }
}

