/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.tcpunixsocketproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.rnorth.tcpunixsocketproxy.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyPump {
    private static final Logger logger = LoggerFactory.getLogger(ProxyPump.class);
    private static final int COPY_BUFFER_SIZE = 4096;
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new DaemonThreadFactory());

    public ProxyPump(Socket clientSocket, Socket serverSocket) throws IOException {
        InputStream fromClient = clientSocket.getInputStream();
        OutputStream toClient = clientSocket.getOutputStream();
        InputStream fromServer = serverSocket.getInputStream();
        OutputStream toServer = serverSocket.getOutputStream();
        EXECUTOR.submit(() -> {
            this.copyUntilFailure(fromClient, toServer);
            logger.trace("C->S died, closing sockets");
            this.quietlyClose(serverSocket);
            this.quietlyClose(clientSocket);
        });
        EXECUTOR.submit(() -> {
            this.copyUntilFailure(fromServer, toClient);
            logger.trace("S->C died, closing sockets");
            this.quietlyClose(serverSocket);
            this.quietlyClose(clientSocket);
        });
    }

    private void copyUntilFailure(InputStream from, OutputStream to) {
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = from.read(buffer)) != -1) {
                to.write(buffer, 0, read);
                to.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void quietlyClose(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

