/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSEncoder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class JSContentHandler
implements ContentHandler,
LexicalHandler {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final char C_COMMA = ',';
    private static final char C_GT = '>';
    private static final char C_LT = '<';
    private static final char C_NSSEP = ':';
    private static final char C_QUOTE = '\'';
    private static final char C_SPACE = ' ';
    private static final JSEncoder ENCODER = new JSEncoder();
    private static final char[] S_TEXT_START = "new T(".toCharArray();
    private static final char[] S_TEXT_END = ")".toCharArray();
    private static final char[] S_PROCINSTR_START = "<?".toCharArray();
    private static final char[] S_PROCINSTR_END = "?>".toCharArray();
    private static final char[] S_OBJECT_START = "{".toCharArray();
    private static final char[] S_OBJECT_END = "}".toCharArray();
    private static final char[] S_EOL = System.getProperty("line.separator").toCharArray();
    private static final char[] S_ELEMENT_START = "new E(".toCharArray();
    private static final char[] S_ELEMENT_END_START_TAG = ",[".toCharArray();
    private static final char[] S_ELEMENT_END = "])".toCharArray();
    private static final char[] S_ELEMENT_CLOSE = ")".toCharArray();
    private static final char[] S_DOCUMENT_START = "(".toCharArray();
    private static final char[] S_DOCUMENT_ENF = ");".toCharArray();
    private static final char[] S_DOCUMENT_3 = "\"?>".toCharArray();
    private static final char[] S_COMMENT_START = "new C('".toCharArray();
    private static final char[] S_COMMENT_END = "')".toCharArray();
    private static final char[] S_CDATA_START = "new D('".toCharArray();
    private static final char[] S_CDATA_END = "')".toCharArray();
    private static final char[] S_ATTRIBUTES_START = ",{".toCharArray();
    private static final char[] S_ATTRIBUTES_END = "}".toCharArray();
    private static final boolean DEBUG = false;
    protected char[] indentBuffer;
    protected int level;
    protected Writer outputWriter;
    private boolean hangingElement = false;
    private boolean beforeDocumentStart = true;
    private boolean processingDtd = false;
    private boolean processingCdata = false;
    private Locator locator;

    public JSContentHandler() {
    }

    public JSContentHandler(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void close() throws IOException {
        this.outputWriter.close();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.beforeDocumentStart || this.level < 0) {
            return;
        }
        try {
            if (this.level != 0 && !this.closeElement(false) && !this.processingCdata) {
                this.outputWriter.write(44);
            }
            if (!this.processingCdata) {
                this.outputWriter.write(S_TEXT_START);
            }
            this.encodeText(ch, start, length);
            if (!this.processingCdata) {
                this.outputWriter.write(S_TEXT_END);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endDocument() throws SAXException {
        this.beforeDocumentStart = true;
        if (this.level != 0) {
            throw new SAXException(Messages.getMessage((String)"OPEN_CLOSE_TAGS_DO_NOT_MATCH_ERROR"));
        }
        try {
            this.outputWriter.write(S_EOL);
            this.outputWriter.flush();
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.level;
        if (this.closeElement(true)) {
            return;
        }
        try {
            this.outputWriter.write(S_ELEMENT_END);
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    protected boolean closeElement(boolean endElement) throws SAXException {
        if (!this.hangingElement) {
            return false;
        }
        try {
            if (endElement) {
                this.outputWriter.write(S_ELEMENT_CLOSE);
            } else {
                this.outputWriter.write(S_ELEMENT_END_START_TAG);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
        this.hangingElement = false;
        return true;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    public String getSystemId() {
        return this.locator == null ? null : this.locator.getSystemId();
    }

    public int getLineNumber() {
        return this.locator == null ? -1 : this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator == null ? -1 : this.locator.getColumnNumber();
    }

    protected String getLocation() {
        if (this.locator == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(" (");
        if (this.getSystemId() != null) {
            buf.append(this.getSystemId());
            buf.append(' ');
        }
        buf.append("line " + this.getLineNumber());
        buf.append(" col " + this.getColumnNumber());
        buf.append(')');
        return buf.toString();
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.beforeDocumentStart = false;
        this.processingCdata = false;
        this.level = 0;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (!this.closeElement(false) && this.level > 0) {
                this.outputWriter.write(44);
            }
            this.outputWriter.write(S_ELEMENT_START);
            this.outputWriter.write(39);
            this.outputWriter.write(qName);
            this.outputWriter.write(39);
            this.outputWriter.write(S_ATTRIBUTES_START);
            for (int x = 0; x < attributes.getLength(); ++x) {
                String attrName;
                if (0 != x) {
                    this.outputWriter.write(44);
                    this.outputWriter.write(32);
                }
                if ((attrName = attributes.getQName(x)).equalsIgnoreCase("class")) {
                    attrName = "className";
                }
                this.outputWriter.write(39);
                this.outputWriter.write(attrName);
                this.outputWriter.write(39);
                this.outputWriter.write(58);
                this.encodeAttributeValue(attributes, x);
            }
            this.outputWriter.write(S_ATTRIBUTES_END);
            ++this.level;
            this.hangingElement = true;
        }
        catch (IOException e) {
            throw new SAXException("write error", e);
        }
    }

    protected void encodeAttributeValue(Attributes attributes, int idx) throws SAXException, IOException {
        this.outputWriter.write(39);
        this.encode(attributes.getValue(idx));
        this.outputWriter.write(39);
    }

    protected void encodeText(char[] chars, int start, int length) throws SAXException, IOException {
        this.encode(chars, start, length);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.beforeDocumentStart || this.level < 0) {
            return;
        }
        try {
            if (!this.closeElement(false) && this.level != 0) {
                this.outputWriter.write(44);
            }
            this.outputWriter.write(S_COMMENT_START);
            this.encode(ch, start, length);
            this.outputWriter.write(S_COMMENT_END);
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.beforeDocumentStart || this.level < 0) {
            return;
        }
        try {
            if (this.closeElement(false)) {
                return;
            }
            this.outputWriter.write(S_CDATA_END);
            this.processingCdata = false;
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (this.beforeDocumentStart || this.level < 0) {
            return;
        }
        try {
            if (!this.closeElement(false) && this.level != 0) {
                this.outputWriter.write(44);
            }
            this.outputWriter.write(S_CDATA_START);
            this.processingCdata = true;
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    protected void writeIndent(int indent) throws SAXException {
        try {
            this.outputWriter.write("\n".toCharArray(), 0, 1);
            if (indent > 0) {
                this.outputWriter.write(this.assureIndentBuffer(indent), 0, indent);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    private char[] assureIndentBuffer(int size) {
        if (this.indentBuffer == null || this.indentBuffer.length < size) {
            this.indentBuffer = new char[size];
            Arrays.fill(this.indentBuffer, ' ');
        }
        return this.indentBuffer;
    }

    protected void encode(String data) throws SAXException {
        char[] array = data.toCharArray();
        this.encode(array, 0, array.length);
    }

    protected void encode(char[] data) throws SAXException {
        this.encode(data, 0, data.length);
    }

    protected void encode(char[] data, int start, int length) throws SAXException {
        int end = start + length;
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        if (start < 0 || start > data.length || length < 0 || end > data.length || end < 0) {
            throw new IndexOutOfBoundsException("Invalid data");
        }
        if (length == 0) {
            return;
        }
        try {
            for (int x = start; x < end; ++x) {
                char c = data[x];
                if (ENCODER.compile(c)) continue;
                if (start != x) {
                    this.outputWriter.write(data, start, x - start);
                }
                this.outputWriter.write(ENCODER.encode(c));
                start = x + 1;
            }
            if (start != end) {
                this.outputWriter.write(data, start, end - start);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write error", e);
        }
    }

    protected boolean isProcessingCdata() {
        return this.processingCdata;
    }

    protected boolean isBeforeDocumentStart() {
        return this.beforeDocumentStart;
    }
}

