/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.tristatemanycheckbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.extensions.component.tristatemanycheckbox.TriStateManyCheckbox;
import org.primefaces.renderkit.SelectManyRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriStateManyCheckboxRenderer
extends SelectManyRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Map) {
            Map mapSub = (Map)submittedValue;
            ArrayList keyValues = new ArrayList(mapSub.keySet());
            LinkedHashMap<String, Object> mapSubConv = new LinkedHashMap<String, Object>();
            TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
            Converter converter = checkbox.getConverter();
            if (converter != null) {
                for (String keyVal : keyValues) {
                    Object mapVal = converter.getAsObject(context, (UIComponent)checkbox, (String)mapSub.get(keyVal));
                    mapSubConv.put(keyVal, mapVal);
                }
                return mapSubConv;
            }
            return mapSub;
        }
        throw new FacesException("Value of '" + component.getClientId() + "'must be a Map instance");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (!TriStateManyCheckboxRenderer.shouldDecode((UIComponent)component)) {
            return;
        }
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        this.decodeBehaviors(context, (UIComponent)checkbox);
        String submitParam = this.getSubmitParam(context, (UISelectMany)checkbox);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] valuesArray = null;
        if (params.containsKey(submitParam)) {
            valuesArray = (String[])params.get(submitParam);
        }
        checkbox.setSubmittedValue(this.getSubmitedMap(context, checkbox, valuesArray));
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, TriStateManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanycheckbox ui-widget" : "ui-selectmanycheckbox ui-widget " + styleClass;
        writer.startElement("table", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, checkbox);
        writer.endElement("table");
    }

    protected void encodeSelectItems(FacesContext context, TriStateManyCheckbox checkbox) throws IOException {
        boolean pageDirection;
        ResponseWriter writer = context.getResponseWriter();
        List selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Map<String, Object> values = this.getValues((UIComponent)checkbox);
        Map<String, Object> submittedMap = this.getSubmittedFromComp((UIComponent)checkbox);
        String layout = checkbox.getLayout();
        boolean bl = pageDirection = layout != null && layout.equals("pageDirection");
        if (submittedMap != null) {
            values = submittedMap;
        }
        if (converter != null && submittedMap == null) {
            for (String keyMapO : values.keySet()) {
                String keyValue = converter.getAsString(context, (UIComponent)checkbox, values.get(keyMapO));
                values.put(keyMapO, keyValue);
            }
        }
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            ++idx;
            if (pageDirection) {
                writer.startElement("tr", null);
            }
            this.encodeOption(context, (UIInput)checkbox, values, converter, selectItem, idx);
            if (!pageDirection) continue;
            writer.endElement("tr");
        }
    }

    protected void encodeOption(FacesContext context, UIInput component, Map<String, Object> values, Converter converter, SelectItem option, int idx) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        String itemValueAsString = String.valueOf(option.getValue());
        String name = checkbox.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean disabled = option.isDisabled() || checkbox.isDisabled();
        String itemValue = (String)option.getValue();
        int valueInput = this.getValueForInput(context, component, itemValue, values, converter);
        if (option.isNoSelectionOption() && values != null && "".equals(itemValue)) {
            return;
        }
        writer.startElement("td", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        this.encodeOptionInput(context, checkbox, id, name, disabled, itemValueAsString, valueInput);
        this.encodeOptionOutput(context, checkbox, valueInput, disabled);
        writer.endElement("div");
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeOptionLabel(context, checkbox, id, option, disabled);
        writer.endElement("td");
    }

    protected void encodeOptionInput(FacesContext context, TriStateManyCheckbox checkbox, String id, String name, boolean disabled, String value, int valueInput) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("value", (Object)valueInput, null);
        writer.writeAttribute("itemValue", (Object)value, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checkbox.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)checkbox.getOnchange(), null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionOutput(FacesContext context, TriStateManyCheckbox checkbox, int valCheck, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        styleClass = valCheck == 1 || valCheck == 2 ? styleClass + " ui-state-active" : styleClass;
        styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
        String stateOneIconClass = checkbox.getStateOneIcon() != null ? "ui-icon " + checkbox.getStateOneIcon() : "";
        String stateTwoIconClass = checkbox.getStateTwoIcon() != null ? "ui-icon " + checkbox.getStateTwoIcon() : "ui-icon ui-icon-check";
        String stataThreeIconClass = checkbox.getStateThreeIcon() != null ? "ui-icon " + checkbox.getStateThreeIcon() : "ui-icon ui-icon-closethick";
        String statesIconsClasses = "[\"" + stateOneIconClass + "\",\"" + stateTwoIconClass + "\",\"" + stataThreeIconClass + "\"]";
        String iconClass = "ui-chkbox-icon";
        if (valCheck == 0) {
            iconClass = iconClass + " " + stateOneIconClass;
        } else if (valCheck == 1) {
            iconClass = iconClass + " " + stateTwoIconClass;
        } else if (valCheck == 2) {
            iconClass = iconClass + " " + stataThreeIconClass;
        }
        writer.write("<div class=\"" + styleClass + "\" data-iconstates='" + statesIconsClasses + "'>" + "<span class=\"" + iconClass + "\"></span></div>");
    }

    protected void encodeScript(FacesContext context, TriStateManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('TriStateManyCheckbox','" + checkbox.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)checkbox);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeOptionLabel(FacesContext context, TriStateManyCheckbox checkbox, String containerClientId, SelectItem option, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)containerClientId, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }

    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    protected int getValueForInput(FacesContext context, UIInput component, String itemValue, Map<String, Object> valueArray, Converter converter) {
        try {
            int retInt = 0;
            if (itemValue == null || valueArray == null) {
                return retInt;
            }
            if (valueArray.containsKey(itemValue)) {
                retInt = Integer.valueOf((String)valueArray.get(itemValue));
                return retInt % 3;
            }
            return retInt;
        }
        catch (NumberFormatException ex) {
            throw new FacesException("State of '" + component.getClientId() + "' must be an integer representation");
        }
    }

    protected Map<String, Object> getValues(UIComponent component) {
        UISelectMany selectMany = (UISelectMany)component;
        Object value = selectMany.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new FacesException("Value of '" + component.getClientId() + "'must be a Map instance");
    }

    protected Map<String, Object> getSubmitedMap(FacesContext context, TriStateManyCheckbox checkbox, String[] valuesArray) {
        List selectItems = this.getSelectItems(context, (UIInput)checkbox);
        LinkedHashMap<String, Object> subValues = new LinkedHashMap<String, Object>();
        if (valuesArray != null && valuesArray.length == selectItems.size()) {
            int idx = -1;
            for (SelectItem item : selectItems) {
                String keyMap = (String)item.getValue();
                String valueMap = valuesArray[++idx];
                subValues.put(keyMap, valueMap);
            }
            return subValues;
        }
        return null;
    }

    protected Map<String, Object> getSubmittedFromComp(UIComponent component) {
        TriStateManyCheckbox checkbox = (TriStateManyCheckbox)component;
        Map ret = (Map)checkbox.getSubmittedValue();
        if (ret != null) {
            LinkedHashMap<String, Object> subValues = new LinkedHashMap<String, Object>();
            Set keys = ret.keySet();
            String[] tempArray = (String[])keys.toArray();
            int length = tempArray.length;
            for (int i = length - 1; i >= 0; --i) {
                String key = tempArray[i];
                Object val = ret.get(key);
                subValues.put(key, val);
            }
            return subValues;
        }
        return null;
    }
}

