/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.blockui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.blockui.BlockUI;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.renderkit.CoreRenderer;

public class BlockUIRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        this.encodeMarkup(fc, component);
        this.encodeScript(fc, component);
    }

    protected void encodeMarkup(FacesContext fc, UIComponent component) throws IOException {
        BlockUI blockUI = (BlockUI)component;
        if (blockUI.getContent() == null && blockUI.getChildCount() > 0) {
            ResponseWriter writer = fc.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(blockUI.getClientId(fc) + "_content"), null);
            writer.writeAttribute("style", (Object)"display: none;", null);
            this.renderChildren(fc, component);
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext fc, UIComponent component) throws IOException {
        String eventRegEx;
        ResponseWriter writer = fc.getResponseWriter();
        BlockUI blockUI = (BlockUI)component;
        String clientId = blockUI.getClientId(fc);
        String source = blockUI.getSource();
        UIComponent sourceComponent = source == null ? blockUI.getParent() : blockUI.findComponent(source);
        if (sourceComponent == null) {
            throw new FacesException("Cannot find source for blockUI component '" + clientId + "'.");
        }
        String jqSource = ComponentUtils.escapeJQueryId((String)sourceComponent.getClientId(fc));
        String jqTarget = null;
        String target = blockUI.getTarget();
        if (target != null) {
            UIComponent targetComponent = blockUI.findComponent(target);
            if (targetComponent == null) {
                throw new FacesException("Cannot find target for blockUI component '" + target + "'.");
            }
            jqTarget = ComponentUtils.escapeJQueryId((String)targetComponent.getClientId(fc));
        } else if (blockUI.getTargetSelector() != null) {
            jqTarget = blockUI.getTargetSelector();
        }
        if (jqTarget == null) {
            throw new FacesException("Cannot determinate target for blockUI component '" + clientId + "'.");
        }
        String jqContent = null;
        boolean isContentExtern = false;
        if (blockUI.getContent() != null) {
            UIComponent contentComponent = blockUI.findComponent(blockUI.getContent());
            if (contentComponent == null) {
                throw new FacesException("Cannot find content for blockUI component '" + clientId + "'.");
            }
            jqContent = ComponentUtils.escapeJQueryId((String)contentComponent.getClientId(fc));
            isContentExtern = true;
        } else if (blockUI.getChildCount() > 0) {
            jqContent = ComponentUtils.escapeJQueryId((String)(clientId + "_content"));
        }
        String events = blockUI.getEvent();
        if (StringUtils.isBlank((CharSequence)events)) {
            eventRegEx = "/javax.faces.source=" + source + "(.)*$/";
        } else {
            String[] arrEvents = events.split("[\\s,]+");
            StringBuilder sb = new StringBuilder("/");
            for (int i = 0; i < arrEvents.length; ++i) {
                sb.append("javax.faces.behavior.event");
                sb.append("=");
                sb.append(arrEvents[i]);
                if (i + 1 >= arrEvents.length) continue;
                sb.append("|");
            }
            sb.append("/");
            eventRegEx = sb.toString();
        }
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        String widgetVar = blockUI.resolveWidgetVar();
        writer.write("PrimeFacesExt.cw('BlockUI', '" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",source:'" + jqSource + "'");
        writer.write(",target:'" + jqTarget + "'");
        if (jqContent != null) {
            writer.write(",content:'" + jqContent + "'");
        } else {
            writer.write(",content:null");
        }
        writer.write(",contentExtern:" + isContentExtern);
        writer.write(",regEx:" + eventRegEx + "},true);");
        if (blockUI.isAutoShow()) {
            writer.write(widgetVar + ".setupAjaxSend();");
            writer.write(widgetVar + ".setupAjaxComplete();");
        }
        writer.write("});");
        this.endScript(writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) throws IOException {
    }
}

