/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.behavior.javascript;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.extensions.behavior.javascript.JavascriptBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptBehaviorHandler
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event;
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute disabled = this.getAttribute("disabled");

    public JavascriptBehaviorHandler(BehaviorConfig config) {
        super((TagConfig)config);
        this.event = this.getAttribute("event");
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        String eventName = this.getEventName();
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo;
            boolean tagApplied = false;
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(faceletContext, parent, eventName);
                tagApplied = true;
            }
            if (null == (componentBeanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Composite component does not have BeanInfo attribute.");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Composite component BeanInfo does not have BeanDescriptor.");
            }
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (targetList == null && !tagApplied) {
                throw new TagException(this.tag, "Composite component does not support behavior events.");
            }
            boolean supportedEvent = false;
            if (targetList != null) {
                for (AttachedObjectTarget target : targetList) {
                    if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                    BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                    if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                    supportedEvent = true;
                    break;
                }
            }
            if (supportedEvent) {
                this.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
            } else if (!tagApplied) {
                throw new TagException(this.tag, "Event \"" + eventName + "\" is not supported by composite component.");
            }
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(faceletContext, parent, eventName);
        } else {
            throw new TagException(this.tag, "Unable to attach <pe:javascript> to non-ClientBehaviorHolder parent.");
        }
    }

    public String getEventName() {
        return this.event != null ? this.event.getValue() : null;
    }

    public void applyAttachedObject(FaceletContext context, UIComponent component, String eventName) {
        String eventToUse;
        ClientBehaviorHolder holder = (ClientBehaviorHolder)component;
        String string = eventToUse = eventName == null ? holder.getDefaultEventName() : eventName;
        if (eventToUse == null) {
            throw new TagException(this.tag, "Event attribute and default event could not be determined.");
        }
        Collection eventNames = holder.getEventNames();
        if (!eventNames.contains(eventToUse)) {
            throw new TagException(this.tag, "Event \"" + eventToUse + "\" is not supported.");
        }
        JavascriptBehavior javascriptBehavior = this.createJavascriptBehavior(context, eventToUse);
        holder.addClientBehavior(eventToUse, (ClientBehavior)javascriptBehavior);
    }

    private JavascriptBehavior createJavascriptBehavior(FaceletContext faceletContext, String eventName) {
        Application application = faceletContext.getFacesContext().getApplication();
        JavascriptBehavior behavior = (JavascriptBehavior)application.createBehavior("org.primefaces.extensions.behavior.JavascriptBehavior");
        this.setBehaviorAttribute(faceletContext, behavior, this.disabled, Boolean.class);
        this.setBehaviorAttribute(faceletContext, behavior, this.execute, String.class);
        return behavior;
    }

    public String getFor() {
        return null;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        this.applyAttachedObject(faceletContext, parent, this.getEventName());
    }

    private void setBehaviorAttribute(FaceletContext faceletContext, JavascriptBehavior behavior, TagAttribute attribute, Class<?> type) {
        if (attribute != null) {
            behavior.setValueExpression(attribute.getLocalName(), attribute.getValueExpression(faceletContext, type));
        }
    }

    public List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return this.getAttachedObjectHandlers(component, true);
    }

    public List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map attributes = component.getAttributes();
        ArrayList result = (ArrayList)attributes.get("javax.faces.RetargetableHandlers");
        if (result == null) {
            if (create) {
                result = new ArrayList();
                attributes.put("javax.faces.RetargetableHandlers", result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }
}

