/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.powermock.core.spi.testresult.Result;
import org.powermock.core.spi.testresult.TestMethodResult;
import org.powermock.tests.utils.PowerMockTestNotifier;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;

class NotificationBuilder {
    private static final Pattern methodDisplayNameRgx = Pattern.compile("^[^\\(\\[]++");
    private final Method[] testMethods;
    private final List<?> pendingTestInstances;
    private final PowerMockTestNotifier powerMockTestNotifier;
    private DetectedTestRunBehaviour behaviour = DetectedTestRunBehaviour.PENDING;
    private Description currentDescription;
    private Object currentTestInstance;
    private String testClassName;
    private Object latestTestInstance;
    private Method latestMethod;
    private static final Object[] unsupportedMethodArgs = new Object[0];
    private final Map<Object, List<Method>> methodsPerInstance = new IdentityHashMap<Object, List<Method>>(){

        @Override
        public List<Method> get(Object key) {
            if (!this.containsKey(key)) {
                this.put(key, new LinkedList());
            }
            return (List)super.get(key);
        }
    };
    private final Map<Description, OngoingTestRun> ongoingTestRuns = new IdentityHashMap<Description, OngoingTestRun>();

    public NotificationBuilder(Method[] testMethods, PowerMockTestNotifier notifier, List<?> pendingTestInstances) {
        this.testMethods = testMethods;
        this.pendingTestInstances = pendingTestInstances;
        this.powerMockTestNotifier = notifier;
    }

    private Method determineTestMethod(Description d) {
        Matcher matchMethodName = methodDisplayNameRgx.matcher(d.getDisplayName());
        matchMethodName.find();
        String methodName = matchMethodName.group();
        boolean latestTestMethodCanBeRepeated = false;
        for (Method m : this.testMethods) {
            if (!m.getName().equals(methodName)) continue;
            if (m == this.latestMethod) {
                latestTestMethodCanBeRepeated = true;
                continue;
            }
            this.latestMethod = m;
            return this.latestMethod;
        }
        if (latestTestMethodCanBeRepeated) {
            return this.latestMethod;
        }
        new IllegalArgumentException("Unable to determine method-name from description=" + d + "; - ignored").printStackTrace();
        return null;
    }

    private Class<?> reloadParamType(Class<?> testClass, Class<?> typeToReload) {
        if (typeToReload.isPrimitive() || testClass.getClassLoader() == typeToReload.getClassLoader()) {
            return typeToReload;
        }
        if (typeToReload.isArray()) {
            Class<?> newComponentType = this.reloadParamType(testClass, typeToReload.getComponentType());
            if (newComponentType == typeToReload.getComponentType()) {
                return typeToReload;
            }
            return Array.newInstance(newComponentType, 0).getClass();
        }
        try {
            return Class.forName(typeToReload.getName(), true, testClass.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }

    private Method reloadMethod(Class<?> testClass, Method m) {
        if (testClass.getClassLoader() == m.getDeclaringClass().getClassLoader()) {
            return m;
        }
        if (!m.getDeclaringClass().getName().equals(testClass.getName())) {
            return this.reloadMethod(testClass.getSuperclass(), m);
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = this.reloadParamType(testClass, paramTypes[i]);
        }
        try {
            return testClass.getDeclaredMethod(m.getName(), paramTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex);
        }
    }

    void testSuiteStarted(Class<?> testClass) {
        for (int i = 0; i < this.testMethods.length; ++i) {
            this.testMethods[i] = this.reloadMethod(testClass, this.testMethods[i]);
        }
        this.powerMockTestNotifier.notifyBeforeTestSuiteStarted(testClass, this.testMethods);
        this.testClassName = testClass.getName();
    }

    void testStartHasBeenFired(Description d) {
        OngoingTestRun oldTestRun = this.ongoingTestRuns.get(d);
        if (null != oldTestRun && null != oldTestRun.getResult()) {
            throw new IllegalStateException("Fired testrun is already running: " + d);
        }
        this.currentDescription = d;
        switch (this.behaviour) {
            case PENDING: {
                this.behaviour = DetectedTestRunBehaviour.START_FIRES_FIRST;
            }
            case START_FIRES_FIRST: {
                return;
            }
            case TEST_INSTANCE_CREATED_FIRST: {
                if (this.currentTestInstance == this.latestTestInstance) {
                    this.behaviour = DetectedTestRunBehaviour.TEST_INSTANCES_ARE_REUSED;
                }
            }
            case TEST_INSTANCES_ARE_REUSED: {
                this.latestTestInstance = this.currentTestInstance;
                this.methodsPerInstance.get(this.currentTestInstance).add((NotificationBuilder)this.new OngoingTestRun((Description)d, (Object)this.currentTestInstance).testMethod);
                return;
            }
            case ALL_TESTINSTANCES_ARE_CREATED_FIRST: {
                System.err.println("Notifications are not supported when all test-instances are created first!");
                return;
            }
        }
        throw new AssertionError();
    }

    void testInstanceCreated(Object newTestInstance) {
        switch (this.behaviour) {
            case PENDING: {
                this.behaviour = DetectedTestRunBehaviour.TEST_INSTANCE_CREATED_FIRST;
                this.currentTestInstance = newTestInstance;
                return;
            }
            case TEST_INSTANCE_CREATED_FIRST: {
                if (this.methodsPerInstance.isEmpty()) {
                    this.behaviour = DetectedTestRunBehaviour.ALL_TESTINSTANCES_ARE_CREATED_FIRST;
                } else if (this.currentTestInstance == this.latestTestInstance) {
                    this.currentTestInstance = newTestInstance;
                } else {
                    this.behaviour = DetectedTestRunBehaviour.INCONSISTENT_BEHAVIOUR;
                }
                return;
            }
            case ALL_TESTINSTANCES_ARE_CREATED_FIRST: 
            case INCONSISTENT_BEHAVIOUR: {
                System.err.println("Notifications are not supported for behaviour " + (Object)((Object)this.behaviour));
                return;
            }
            case START_FIRES_FIRST: {
                this.currentTestInstance = this.latestTestInstance = newTestInstance;
                this.latestMethod = this.determineTestMethod(this.currentDescription);
                this.methodsPerInstance.get(newTestInstance).add((NotificationBuilder)this.new OngoingTestRun((Description)this.currentDescription, (Object)newTestInstance).testMethod);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown behaviour: " + (Object)((Object)this.behaviour)));
    }

    void testIgnored(Description d) {
        if (!this.notify(d, Result.IGNORED) && DetectedTestRunBehaviour.TEST_INSTANCE_CREATED_FIRST == this.behaviour && this.currentTestInstance != this.latestTestInstance) {
            this.currentTestInstance = this.latestTestInstance;
        }
    }

    void assumptionFailed(Description d) {
        this.notify(d, Result.IGNORED);
    }

    void failure(Failure f) {
        this.notify(f.getDescription(), Result.FAILED);
    }

    void testFinished(Description d) {
        this.notify(d, Result.SUCCESSFUL);
    }

    private boolean notify(Description d, Result result) {
        OngoingTestRun testRun = this.ongoingTestRuns.get(d);
        if (null == testRun) {
            return false;
        }
        testRun.report(result);
        return true;
    }

    private class OngoingTestRun
    implements TestMethodResult {
        final Description testDescription;
        final Object testInstance;
        final Method testMethod;
        private Result result;

        OngoingTestRun(Description testDescription, Object testInstance) {
            this.testDescription = testDescription;
            this.testInstance = testInstance;
            this.testMethod = NotificationBuilder.this.determineTestMethod(testDescription);
            NotificationBuilder.this.pendingTestInstances.remove(testInstance);
            Class<?> testClass = this.testClass();
            new MockPolicyInitializerImpl(testClass).initialize(testClass.getClassLoader());
            NotificationBuilder.this.powerMockTestNotifier.notifyBeforeTestMethod(testInstance, this.testMethod, unsupportedMethodArgs);
            NotificationBuilder.this.ongoingTestRuns.put(testDescription, this);
        }

        Class<?> testClass() {
            if (null == NotificationBuilder.this.testClassName) {
                return this.testInstance.getClass();
            }
            try {
                return Class.forName(NotificationBuilder.this.testClassName, false, this.testInstance.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                return this.testInstance.getClass();
            }
        }

        void report(Result result) {
            if (null != this.result && Result.SUCCESSFUL == result || this.result == result) {
                return;
            }
            if (null != this.result) {
                new IllegalStateException("Will report an unexpected result-notification " + result + " after previously received notification " + this.result).printStackTrace();
            }
            this.result = result;
            NotificationBuilder.this.powerMockTestNotifier.notifyAfterTestMethod(this.testInstance, this.testMethod, unsupportedMethodArgs, (TestMethodResult)this);
        }

        public Result getResult() {
            return this.result;
        }
    }

    static enum DetectedTestRunBehaviour {
        PENDING,
        START_FIRES_FIRST,
        TEST_INSTANCE_CREATED_FIRST,
        ALL_TESTINSTANCES_ARE_CREATED_FIRST,
        TEST_INSTANCES_ARE_REUSED,
        INCONSISTENT_BEHAVIOUR;

    }
}

