/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.jmock.ClassImposterizer;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.powermock.api.mockito.internal.invocation.MockitoMethodInvocationControl;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCreator {
    public static <T> T mock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        if (type == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        Object mock = null;
        String mockName = MockCreator.toInstanceName(type);
        MockRepository.addAfterMethodRunner((Runnable)new MockitoStateCleaner());
        Class typeToMock = MockCreator.isFinalJavaSystemClass(type) ? new ClassReplicaCreator().createClassReplica(type) : type;
        MockData<T> mockData = MockCreator.createMethodInvocationControl(mockName, typeToMock, methods, isSpy, delegator, mockSettings);
        mock = mockData.getMock();
        if (MockCreator.isFinalJavaSystemClass(type) && !isStatic) {
            mock = Whitebox.newInstance((Class)type);
            DefaultFieldValueGenerator.fillWithDefaultValues((Object)mock);
        }
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl((Class)type, (MethodInvocationControl)mockData.getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl((Object)mock, (MethodInvocationControl)mockData.getMethodInvocationControl());
        }
        if (isSpy) {
            new LenientCopyTool().copyToMock(delegator, mock);
        }
        return (T)mock;
    }

    private static <T> boolean isFinalJavaSystemClass(Class<T> type) {
        return type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> MockData<T> createMethodInvocationControl(String mockName, Class<T> type, Method[] methods, boolean isSpy, Object delegator, MockSettings mockSettings) {
        MockSettingsImpl settings;
        if (mockSettings == null) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(MockCreator.class.getClassLoader());
            try {
                settings = (MockSettingsImpl)Mockito.withSettings();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        } else {
            settings = (MockSettingsImpl)mockSettings;
        }
        if (isSpy) {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        }
        settings.setMockName((MockName)new MockNameImpl(mockName));
        InternalMockHandler mockHandler = new MockHandlerFactory().create((MockCreationSettings)settings);
        MethodInterceptorFilter filter = new MethodInterceptorFilter(mockHandler, (MockCreationSettings)settings);
        Object mock = ClassImposterizer.INSTANCE.imposterise((MethodInterceptor)filter, type, new Class[0]);
        MockitoMethodInvocationControl invocationControl = new MockitoMethodInvocationControl(filter, isSpy && delegator == null ? new Object() : delegator, mock, methods);
        return new MockData<Object>(invocationControl, mock);
    }

    private static String toInstanceName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            return clazz.getName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockitoStateCleaner
    implements Runnable {
        private MockitoStateCleaner() {
        }

        @Override
        public void run() {
            this.clearMockProgress();
            this.clearConfiguration();
        }

        private void clearMockProgress() {
            this.clearThreadLocalIn(ThreadSafeMockingProgress.class);
        }

        private void clearConfiguration() {
            this.clearThreadLocalIn(GlobalConfiguration.class);
        }

        private void clearThreadLocalIn(Class<?> cls) {
            ((ThreadLocal)Whitebox.getInternalState(cls, ThreadLocal.class)).set(null);
            Class clazz = ClassLoaderUtil.hasClass(cls, (ClassLoader)ClassLoader.getSystemClassLoader()) ? ClassLoaderUtil.loadClass(cls, (ClassLoader)ClassLoader.getSystemClassLoader()) : ClassLoaderUtil.loadClass(cls, (ClassLoader)cls.getClassLoader());
            ((ThreadLocal)Whitebox.getInternalState((Object)clazz, ThreadLocal.class)).set(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        MockData(MockitoMethodInvocationControl methodInvocationControl, T mock) {
            this.methodInvocationControl = methodInvocationControl;
            this.mock = mock;
        }

        public MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public T getMock() {
            return this.mock;
        }
    }
}

