/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.powermock.api.extension.listener.AnnotationMockMetadata;
import org.powermock.reflect.Whitebox;

class AnnotationMockScanner {
    private final Class<? extends Annotation> annotation;

    public AnnotationMockScanner(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public List<AnnotationMockMetadata> scan(Object instance) throws Exception {
        ArrayList<AnnotationMockMetadata> mocksMetadata = new ArrayList<AnnotationMockMetadata>();
        Set<Field> fields = this.getFields(instance);
        for (Field field : fields) {
            if (field.get(instance) != null) continue;
            mocksMetadata.add(new AnnotationMockMetadata(this.annotation, field));
        }
        return mocksMetadata;
    }

    private Set<Field> getFields(Object instance) {
        Set fields = this.annotation != null ? Whitebox.getFieldsAnnotatedWith((Object)instance, this.annotation, (Class[])new Class[0]) : Whitebox.getAllInstanceFields((Object)instance);
        return fields;
    }
}

