/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeverityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeverityUtil.class);

    private SeverityUtil() {
    }

    public static float estimateCvssV2(String severity) {
        switch (severity == null ? "none" : severity.toLowerCase()) {
            case "critical": 
            case "high": {
                return 10.0f;
            }
            case "moderate": 
            case "medium": {
                return 6.9f;
            }
            case "info": 
            case "informational": {
                return 0.0f;
            }
        }
        return 3.9f;
    }

    public static String unscoredToSeveritytext(String severity) {
        switch (Severity.forUnscored(severity)) {
            case CRITICAL: 
            case HIGH: 
            case MEDIUM: 
            case LOW: 
            case INFO: {
                return severity;
            }
        }
        String sevText = "0.0".equals(severity) ? "Unknown" : severity;
        return sevText + " (not recognized; assumed to be critical)";
    }

    public static float estimatedSortAdjustedCVSSv3(String severity) {
        switch (Severity.forUnscored(severity)) {
            case CRITICAL: {
                return 10.2f;
            }
            case HIGH: {
                return 7.0f;
            }
            case MEDIUM: {
                return 4.0f;
            }
            case LOW: {
                return 0.1f;
            }
            case INFO: {
                return 0.0f;
            }
        }
        LOGGER.debug("Unrecognized unscored textual severity: {}, assuming critical score as worst-case estimate for sorting", (Object)severity);
        return 10.1f;
    }

    public static float sortAdjustedCVSSv3BaseScore(float cvssV3BaseScore) {
        if (cvssV3BaseScore >= 9.0f) {
            return cvssV3BaseScore + 1.3f;
        }
        return cvssV3BaseScore;
    }

    private static enum Severity {
        CRITICAL,
        ASSUMED_CRITICAL,
        HIGH,
        MEDIUM,
        LOW,
        INFO;


        public static Severity forUnscored(String value) {
            switch (value == null ? "none" : value.toLowerCase()) {
                case "critical": {
                    return CRITICAL;
                }
                case "high": {
                    return HIGH;
                }
                case "moderate": 
                case "medium": {
                    return MEDIUM;
                }
                case "info": 
                case "informational": {
                    return INFO;
                }
                case "low": 
                case "unknown": 
                case "none": {
                    return LOW;
                }
            }
            return ASSUMED_CRITICAL;
        }
    }
}

