/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NexusV3Search
implements NexusSearch {
    private final Set<String> acceptedClassifiers = new HashSet<String>();
    private final URL rootURL;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusV3Search.class);

    public NexusV3Search(Settings settings, boolean useProxy) throws MalformedURLException {
        this.settings = settings;
        this.useProxy = useProxy;
        this.acceptedClassifiers.add(null);
        String searchUrl = settings.getString("analyzer.nexus.url");
        LOGGER.debug("Nexus Search URL: {}", (Object)searchUrl);
        this.rootURL = new URL(searchUrl);
    }

    @Override
    public MavenArtifact searchSha1(String sha1) throws IOException {
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        ArrayList<MavenArtifact> collectedMatchingArtifacts = new ArrayList<MavenArtifact>(1);
        String continuationToken = this.retrievePageAndAddMatchingArtifact(collectedMatchingArtifacts, sha1, null);
        while (continuationToken != null && collectedMatchingArtifacts.isEmpty()) {
            continuationToken = this.retrievePageAndAddMatchingArtifact(collectedMatchingArtifacts, sha1, continuationToken);
        }
        if (collectedMatchingArtifacts.isEmpty()) {
            throw new FileNotFoundException("Artifact not found in Nexus");
        }
        return (MavenArtifact)collectedMatchingArtifacts.get(0);
    }

    private String retrievePageAndAddMatchingArtifact(List<MavenArtifact> collectedMatchingArtifacts, String sha1, String continuationToken) throws IOException {
        LOGGER.debug("Search with continuation token {}", (Object)continuationToken);
        URL url = continuationToken == null ? new URL(this.rootURL, String.format("v1/search/?sha1=%s", sha1.toLowerCase())) : new URL(this.rootURL, String.format("v1/search/?sha1=%s&continuationToken=%s", sha1.toLowerCase(), continuationToken));
        LOGGER.debug("Searching Nexus url {}", (Object)url);
        URLConnectionFactory factory = new URLConnectionFactory(this.settings);
        HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
        conn.setDoOutput(true);
        String authHeader = this.buildHttpAuthHeaderValue();
        if (!authHeader.isEmpty()) {
            conn.addRequestProperty("Authorization", authHeader);
        }
        conn.addRequestProperty("Accept", "application/json");
        conn.connect();
        if (conn.getResponseCode() != 200) {
            LOGGER.debug("Could not connect to Nexus received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
            throw new IOException(String.format("Could not connect to Nexus, HTTP response code %d", conn.getResponseCode()));
        }
        String nextContinuationToken = this.parseResponse(conn, sha1, collectedMatchingArtifacts);
        return nextContinuationToken;
    }

    /*
     * Exception decompiling
     */
    private String parseResponse(HttpURLConnection conn, String sha1, List<MavenArtifact> matchingArtifacts) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean preflightRequest() {
        try {
            URL url = new URL(this.rootURL, "v1/status");
            URLConnectionFactory factory = new URLConnectionFactory(this.settings);
            HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
            conn.addRequestProperty("Accept", "application/json");
            String authHeader = this.buildHttpAuthHeaderValue();
            if (!authHeader.isEmpty()) {
                conn.addRequestProperty("Authorization", authHeader);
            }
            conn.connect();
            if (conn.getResponseCode() != 200) {
                LOGGER.warn("Expected 200 result from Nexus, got {}", (Object)conn.getResponseCode());
                return false;
            }
            if (conn.getContentLength() != 0) {
                LOGGER.warn("Expected empty OK response (content-length 0), got content-length {}", (Object)conn.getContentLength());
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Pre-flight request to Nexus failed: ", (Throwable)e);
            return false;
        }
        return true;
    }

    private String buildHttpAuthHeaderValue() {
        String user = this.settings.getString("analyzer.nexus.username", "");
        String pass = this.settings.getString("analyzer.nexus.password", "");
        String result = "";
        if (user.isEmpty() || pass.isEmpty()) {
            LOGGER.debug("Skip authentication as user and/or password for nexus is empty");
        } else {
            String auth = user + ':' + pass;
            String base64Auth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            result = "Basic " + base64Auth;
        }
        return result;
    }
}

