/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import signature.AbstractGraphBuilder;

public class MoleculeFromSignatureBuilder
extends AbstractGraphBuilder {
    private IChemObjectBuilder builder;
    private IAtomContainer container;

    public MoleculeFromSignatureBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    public void makeEdge(int vertexIndex1, int vertexIndex2, String vertexSymbol1, String vertexSymbol2, String edgeLabel) {
        if (edgeLabel.equals("")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.SINGLE);
        } else if (edgeLabel.equals("=")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.DOUBLE);
        } else if (edgeLabel.equals("#")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.TRIPLE);
        } else if (edgeLabel.equals("p")) {
            IBond bond = (IBond)this.builder.newInstance(IBond.class, new Object[]{this.container.getAtom(vertexIndex1), this.container.getAtom(vertexIndex2), IBond.Order.SINGLE});
            bond.setFlag(32, true);
            this.container.addBond(bond);
        }
    }

    public void makeGraph() {
        this.container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
    }

    public void makeVertex(String label) {
        this.container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{label}));
    }

    public IAtomContainer getAtomContainer() {
        return this.container;
    }
}

