/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.INChIContentProcessorTool;
import org.openscience.cdk.io.formats.INChIFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class INChIReader
extends DefaultChemObjectReader {
    private XMLReader parser;
    private InputStream input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(INChIReader.class);

    public INChIReader(InputStream input) {
        this.input = input;
        this.init();
    }

    public INChIReader() {
        this(new ByteArrayInputStream(new byte[0]));
    }

    public IResourceFormat getFormat() {
        return INChIFormat.getInstance();
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Invalid method call; use SetReader(InputStream) instead.");
    }

    public void setReader(InputStream input) throws CDKException {
        this.input = input;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info((Object)"Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (ParserConfigurationException | SAXException e) {
                logger.warn((Object)"Could not instantiate JAXP/SAX XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)((Object)((Object)this)).getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info((Object)"Using Aelfred2 XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.warn((Object)"Could not instantiate Aelfred2 XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)((Object)((Object)this)).getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info((Object)"Using Xerces XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.warn((Object)"Could not instantiate Xerces XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            logger.error((Object)"Could not instantiate any XML parser!");
        }
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile(object.getBuilder());
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemObjectBuilder bldr) {
        IChemFile cf = null;
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info((Object)"Deactivated validation");
        }
        catch (SAXException e) {
            logger.warn((Object)"Cannot deactivate validation.");
        }
        INChIHandler handler = new INChIHandler(bldr);
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            cf = handler.getChemFile();
        }
        catch (IOException e) {
            logger.error((Object)"IOException: ", new Object[]{e.getMessage()});
            logger.debug((Object)e);
        }
        catch (SAXException saxe) {
            logger.error((Object)"SAXException: ", new Object[]{saxe.getClass().getName()});
            logger.debug((Object)saxe);
        }
        return cf;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private static final class INChIHandler
    extends DefaultHandler {
        private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(INChIHandler.class);
        private INChIContentProcessorTool inchiTool;
        private IChemFile chemFile;
        private IChemSequence chemSequence;
        private IChemModel chemModel;
        private IAtomContainerSet setOfMolecules;
        private IAtomContainer tautomer;
        private IChemObjectBuilder builder;
        private String currentChars;

        public INChIHandler(IChemObjectBuilder bldr) {
            this.builder = bldr;
            this.inchiTool = new INChIContentProcessorTool();
        }

        public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
            logger.info((Object)("DocType root element: " + name));
            logger.info((Object)("DocType root PUBLIC: " + publicId));
            logger.info((Object)("DocType root SYSTEM: " + systemId));
        }

        @Override
        public void startDocument() {
            this.chemFile = (IChemFile)this.builder.newInstance(IChemFile.class, new Object[0]);
            this.chemSequence = (IChemSequence)this.builder.newInstance(IChemSequence.class, new Object[0]);
            this.chemModel = (IChemModel)this.builder.newInstance(IChemModel.class, new Object[0]);
            this.setOfMolecules = (IAtomContainerSet)this.builder.newInstance(IAtomContainerSet.class, new Object[0]);
        }

        @Override
        public void endDocument() {
            this.chemFile.addChemSequence(this.chemSequence);
        }

        @Override
        public void endElement(String uri, String local, String raw) {
            logger.debug((Object)"end element: ", new Object[]{raw});
            if ("identifier".equals(local)) {
                if (this.tautomer != null) {
                    this.setOfMolecules.addAtomContainer(this.tautomer);
                    this.chemModel.setMoleculeSet(this.setOfMolecules);
                    this.chemSequence.addChemModel(this.chemModel);
                }
            } else if ("formula".equals(local)) {
                if (this.tautomer != null) {
                    logger.info((Object)"Parsing <formula> chars: ", new Object[]{this.currentChars});
                    this.tautomer = this.inchiTool.processFormula((IAtomContainer)this.setOfMolecules.getBuilder().newInstance(IAtomContainer.class, new Object[0]), this.currentChars);
                } else {
                    logger.warn((Object)"Cannot set atom info for empty tautomer");
                }
            } else if ("connections".equals(local)) {
                if (this.tautomer != null) {
                    logger.info((Object)"Parsing <connections> chars: ", new Object[]{this.currentChars});
                    this.inchiTool.processConnections(this.currentChars, this.tautomer, -1);
                } else {
                    logger.warn((Object)"Cannot set dbond info for empty tautomer");
                }
            }
        }

        @Override
        public void startElement(String uri, String local, String raw, Attributes atts) {
            this.currentChars = "";
            logger.debug((Object)"startElement: ", new Object[]{raw});
            logger.debug((Object)"uri: ", new Object[]{uri});
            logger.debug((Object)"local: ", new Object[]{local});
            logger.debug((Object)"raw: ", new Object[]{raw});
            if ("INChI".equals(local)) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!atts.getQName(i).equals("version")) continue;
                    logger.info((Object)"INChI version: ", new Object[]{atts.getValue(i)});
                }
            } else if ("structure".equals(local)) {
                this.tautomer = this.builder.newAtomContainer();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            logger.debug((Object)"character data");
            this.currentChars = this.currentChars + new String(ch, start, length);
        }

        public IChemFile getChemFile() {
            return this.chemFile;
        }
    }
}

