/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.isotopes;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class IsotopeHandler
extends DefaultHandler {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopeHandler.class);
    private String currentChars;
    private List<IIsotope> isotopes;
    private IIsotope workingIsotope;
    private String currentElement;
    private String dictRef;
    private IChemObjectBuilder builder;

    public IsotopeHandler(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    public List<IIsotope> getIsotopes() {
        return this.isotopes;
    }

    @Override
    public void startDocument() {
        this.isotopes = new ArrayList<IIsotope>();
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        logger.debug((Object)"end element: ", new Object[]{raw});
        if ("isotope".equals(local)) {
            if (this.workingIsotope != null) {
                this.isotopes.add(this.workingIsotope);
            }
            this.workingIsotope = null;
        } else if ("isotopeList".equals(local)) {
            this.currentElement = null;
        } else if ("scalar".equals(local)) {
            try {
                if ("bo:exactMass".equals(this.dictRef)) {
                    this.workingIsotope.setExactMass(Double.valueOf(Double.parseDouble(this.currentChars)));
                } else if ("bo:atomicNumber".equals(this.dictRef)) {
                    this.workingIsotope.setAtomicNumber(Integer.valueOf(Integer.parseInt(this.currentChars)));
                } else if ("bo:relativeAbundance".equals(this.dictRef)) {
                    this.workingIsotope.setNaturalAbundance(Double.valueOf(Double.parseDouble(this.currentChars)));
                }
            }
            catch (NumberFormatException exception) {
                logger.error((Object)"The ", new Object[]{this.dictRef, " value is incorrect: ", this.currentChars});
                logger.debug((Object)exception);
            }
        }
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        this.currentChars = "";
        this.dictRef = "";
        logger.debug((Object)"startElement: ", new Object[]{raw});
        logger.debug((Object)"uri: ", new Object[]{uri});
        logger.debug((Object)"local: ", new Object[]{local});
        logger.debug((Object)"raw: ", new Object[]{raw});
        if ("isotope".equals(local)) {
            this.workingIsotope = this.createIsotopeOfElement(this.currentElement, atts);
        } else if ("isotopeList".equals(local)) {
            this.currentElement = this.getElementSymbol(atts);
        } else if ("scalar".equals(local)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"dictRef".equals(atts.getQName(i))) continue;
                this.dictRef = atts.getValue(i);
            }
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.currentChars = this.currentChars + new String(chars, start, length);
    }

    private IIsotope createIsotopeOfElement(String currentElement, Attributes atts) {
        IIsotope isotope = (IIsotope)this.builder.newInstance(IIsotope.class, new Object[]{currentElement});
        for (int i = 0; i < atts.getLength(); ++i) {
            try {
                if ("id".equals(atts.getQName(i))) {
                    isotope.setID(atts.getValue(i));
                    continue;
                }
                if ("number".equals(atts.getQName(i))) {
                    isotope.setMassNumber(Integer.valueOf(Integer.parseInt(atts.getValue(i))));
                    continue;
                }
                if (!"elementType".equals(atts.getQName(i))) continue;
                isotope.setSymbol(atts.getValue(i));
                continue;
            }
            catch (NumberFormatException exception) {
                logger.error((Object)"Value of isotope@", new Object[]{atts.getQName(i), " is not as expected."});
                logger.debug((Object)exception);
            }
        }
        isotope.setNaturalAbundance(Double.valueOf(0.0));
        return isotope;
    }

    private String getElementSymbol(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!"id".equals(atts.getQName(i))) continue;
            return atts.getValue(i);
        }
        return "";
    }
}

