/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class Polarizability {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Polarizability.class);

    private void addExplicitHydrogens(IAtomContainer container) {
        try {
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)container.getBuilder());
            for (IAtom atom : container.atoms()) {
                IAtomType type = matcher.findMatchingAtomType(container, atom);
                AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
            }
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)container.getBuilder());
            hAdder.addImplicitHydrogens(container);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)container);
        }
        catch (Exception ex1) {
            logger.debug((Object)"Error in hydrogen addition");
        }
    }

    public double getPolarizabilitiyFactorForAtom(IAtomContainer atomContainer, IAtom atom) {
        IAtomContainer acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        this.addExplicitHydrogens(acH);
        return this.getKJPolarizabilityFactor(acH, atom);
    }

    public double calculateKJMeanMolecularPolarizability(IAtomContainer atomContainer) {
        double polarizabilitiy = 0.0;
        IAtomContainer acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        this.addExplicitHydrogens(acH);
        for (int i = 0; i < acH.getAtomCount(); ++i) {
            polarizabilitiy += this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
        }
        return polarizabilitiy;
    }

    public double calculateGHEffectiveAtomPolarizability(IAtomContainer atomContainer, IAtom atom, int influenceSphereCutOff, boolean addExplicitH) {
        IAtomContainer acH;
        double polarizabilitiy = 0.0;
        if (addExplicitH) {
            acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
            this.addExplicitHydrogens(acH);
        } else {
            acH = atomContainer;
        }
        ArrayList<IAtom> startAtom = new ArrayList<IAtom>(1);
        startAtom.add(0, atom);
        polarizabilitiy += this.getKJPolarizabilityFactor(acH, atom);
        for (int i = 0; i < acH.getAtomCount(); ++i) {
            if (acH.getAtom(i).equals(atom)) continue;
            double bond = PathTools.breadthFirstTargetSearch((IAtomContainer)acH, startAtom, (IAtom)acH.getAtom(i), (int)0, (int)influenceSphereCutOff);
            if (bond == 1.0) {
                polarizabilitiy += this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
                continue;
            }
            polarizabilitiy += Math.pow(0.5, bond - 1.0) * this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
        }
        return polarizabilitiy;
    }

    public double calculateGHEffectiveAtomPolarizability(IAtomContainer atomContainer, IAtom atom, boolean addExplicitH, int[][] distanceMatrix) {
        IAtomContainer acH;
        double polarizabilitiy = 0.0;
        if (addExplicitH) {
            acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
            this.addExplicitHydrogens(acH);
        } else {
            acH = atomContainer;
        }
        polarizabilitiy += this.getKJPolarizabilityFactor(acH, atom);
        for (int i = 0; i < acH.getAtomCount(); ++i) {
            if (acH.getAtom(i).equals(atom)) continue;
            int atomIndex = atomContainer.indexOf(atom);
            double bond = distanceMatrix[atomIndex][i];
            if (bond == 1.0) {
                polarizabilitiy += this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
                continue;
            }
            polarizabilitiy += Math.pow(0.5, bond - 1.0) * this.getKJPolarizabilityFactor(acH, acH.getAtom(i));
        }
        return polarizabilitiy;
    }

    public double calculateBondPolarizability(IAtomContainer atomContainer, IBond bond) {
        double polarizabilitiy = 0.0;
        IAtomContainer acH = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        this.addExplicitHydrogens(acH);
        if (bond.getAtomCount() == 2) {
            polarizabilitiy += this.getKJPolarizabilityFactor(acH, bond.getBegin());
            polarizabilitiy += this.getKJPolarizabilityFactor(acH, bond.getEnd());
        }
        return polarizabilitiy / 2.0;
    }

    private double getKJPolarizabilityFactor(IAtomContainer atomContainer, IAtom atom) {
        String AtomSymbol;
        double polarizabilitiyFactor = 0.0;
        switch (AtomSymbol = atom.getSymbol()) {
            case "H": {
                polarizabilitiyFactor = 0.387;
                break;
            }
            case "C": {
                if (atom.getFlag(32)) {
                    polarizabilitiyFactor = 1.23;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                    polarizabilitiyFactor = 1.064;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                    if (this.getNumberOfHydrogen(atomContainer, atom) == 0) {
                        polarizabilitiyFactor = 1.382;
                        break;
                    }
                    polarizabilitiyFactor = 1.37;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) != IBond.Order.TRIPLE && atomContainer.getMaximumBondOrder(atom) != IBond.Order.QUADRUPLE) break;
                polarizabilitiyFactor = 1.279;
                break;
            }
            case "N": {
                if (atom.getCharge() != CDKConstants.UNSET && atom.getCharge() < 0.0) {
                    polarizabilitiyFactor = 1.09;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                    polarizabilitiyFactor = 1.094;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                    polarizabilitiyFactor = 1.03;
                    break;
                }
                polarizabilitiyFactor = 0.852;
                break;
            }
            case "O": {
                if (atom.getCharge() != CDKConstants.UNSET && atom.getCharge() == -1.0) {
                    polarizabilitiyFactor = 1.791;
                    break;
                }
                if (atom.getCharge() != CDKConstants.UNSET && atom.getCharge() == 1.0) {
                    polarizabilitiyFactor = 0.422;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                    polarizabilitiyFactor = 0.664;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) != IBond.Order.DOUBLE) break;
                polarizabilitiyFactor = 0.46;
                break;
            }
            case "P": {
                if (atomContainer.getConnectedBondsCount(atom) != 4 || atomContainer.getMaximumBondOrder(atom) != IBond.Order.DOUBLE) break;
                polarizabilitiyFactor = 0.0;
                break;
            }
            case "S": {
                if (atom.getFlag(32)) {
                    polarizabilitiyFactor = 3.38;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                    polarizabilitiyFactor = 3.2;
                    break;
                }
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                    if (this.getNumberOfHydrogen(atomContainer, atom) == 0) {
                        polarizabilitiyFactor = 3.51;
                        break;
                    }
                    polarizabilitiyFactor = 3.5;
                    break;
                }
                polarizabilitiyFactor = 3.42;
                break;
            }
            case "F": {
                polarizabilitiyFactor = 0.296;
                break;
            }
            case "Cl": {
                polarizabilitiyFactor = 2.343;
                break;
            }
            case "Br": {
                polarizabilitiyFactor = 3.5;
                break;
            }
            case "I": {
                polarizabilitiyFactor = 5.79;
            }
        }
        return polarizabilitiyFactor;
    }

    private int getNumberOfHydrogen(IAtomContainer atomContainer, IAtom atom) {
        List bonds = atomContainer.getConnectedBondsList(atom);
        int hCounter = 0;
        for (IBond bond : bonds) {
            IAtom connectedAtom = bond.getOther(atom);
            if (!connectedAtom.getSymbol().equals("H")) continue;
            ++hCounter;
        }
        return hCounter;
    }
}

