/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.InvalidRefNameException;
import org.openrewrite.jgit.api.errors.RefNotFoundException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.ReflogEntry;
import org.openrewrite.jgit.lib.ReflogReader;
import org.openrewrite.jgit.lib.Repository;

public class ReflogCommand
extends GitCommand<Collection<ReflogEntry>> {
    private String ref = "HEAD";

    public ReflogCommand(Repository repo) {
        super(repo);
    }

    public ReflogCommand setRef(String ref) {
        this.checkCallable();
        this.ref = ref;
        return this;
    }

    @Override
    public Collection<ReflogEntry> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            ReflogReader reader = this.repo.getReflogReader(this.ref);
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.ref));
            }
            return reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
        }
    }
}

