/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplaceWriter;
import org.openrewrite.maven.marketplace.RecipeClassLoader;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public class MavenRecipeMarketplaceGenerator {
    private final GroupArtifactVersion gav;
    private final Path recipeJar;
    private final List<Path> classpath;

    public MavenRecipeMarketplaceGenerator(GroupArtifact ga, Path recipeJar, List<Path> classpath) {
        this.gav = new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), "");
        this.recipeJar = recipeJar;
        this.classpath = classpath;
    }

    public RecipeMarketplace generate() {
        try {
            if (Files.notExists(this.recipeJar, new LinkOption[0])) {
                throw new IllegalArgumentException("Recipe JAR does not exist " + this.recipeJar);
            }
            Environment env1 = Environment.builder().scanJar(this.recipeJar.toAbsolutePath(), (Collection)this.classpath.stream().map(Path::toAbsolutePath).collect(Collectors.toList()), RecipeClassLoader.forScanning(this.recipeJar, this.classpath)).build();
            List targetRecipeNames = env1.listRecipeDescriptors().stream().map(RecipeDescriptor::getName).collect(Collectors.toList());
            Environment env2 = Environment.builder().load((ResourceLoader)new ClasspathScanningLoader(new Properties(), (ClassLoader)new RecipeClassLoader(this.recipeJar, this.classpath))).build();
            RecipeMarketplace marketplace = new RecipeMarketplace();
            for (RecipeDescriptor descriptor : env2.listRecipeDescriptors()) {
                if (!targetRecipeNames.contains(descriptor.getName())) continue;
                marketplace.install(RecipeListing.fromDescriptor((RecipeDescriptor)descriptor, (RecipeBundle)new RecipeBundle("maven", this.gav.getGroupId() + ":" + this.gav.getArtifactId(), Objects.requireNonNull(this.gav.getVersion()), null)), descriptor.inferCategoriesFromName(env2));
            }
            return marketplace;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate marketplace for " + this.gav, e);
        }
    }

    public static void main(String[] args) throws IOException {
        String[] gav;
        if (args.length < 3) {
            System.err.println("Usage: java MavenRecipeMarketplaceGenerator <groupId:artifactId> <output-csv-path> <recipe-jar> [classpath-entries...]");
            System.exit(1);
        }
        if ((gav = args[0].split(":")).length != 2) {
            System.err.println("Invalid groupId:artifactId format: " + args[0]);
            System.exit(1);
        }
        String groupId = gav[0];
        String artifactId = gav[1];
        Path outputCsv = Paths.get(args[1], new String[0]);
        Path recipeJar = Paths.get(args[2], new String[0]);
        ArrayList<Path> classpath = new ArrayList<Path>();
        for (int i = 3; i < args.length; ++i) {
            classpath.add(Paths.get(args[i], new String[0]));
        }
        GroupArtifact ga = new GroupArtifact(groupId, artifactId);
        RecipeMarketplace marketplace = new MavenRecipeMarketplaceGenerator(ga, recipeJar, classpath).generate();
        String csv = new RecipeMarketplaceWriter().toCsv(marketplace);
        Files.write(outputCsv, csv.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        System.out.println("Generated marketplace CSV with " + marketplace.getAllRecipes().size() + " recipes");
        System.out.println("Output written to: " + outputCsv.toAbsolutePath());
    }
}

