/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.tools.checkstyle.PropertyType;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.XdocsPropertyType;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.DetailNode;
import org.openrewrite.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import org.openrewrite.tools.checkstyle.utils.JavadocUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class AtclauseOrderCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "at.clause.order";
    private static final String[] DEFAULT_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated"};
    @XdocsPropertyType(value=PropertyType.TOKEN_ARRAY)
    private List<Integer> target = Arrays.asList(14, 15, 154, 9, 8, 10, 199, 203);
    private List<String> tagOrder = Arrays.asList(DEFAULT_ORDER);

    public void setTarget(String ... targets) {
        ArrayList<Integer> customTarget = new ArrayList<Integer>();
        for (String temp : targets) {
            customTarget.add(TokenUtil.getTokenId(temp.trim()));
        }
        this.target = customTarget;
    }

    public void setTagOrder(String ... orders) {
        ArrayList<String> customOrder = new ArrayList<String>();
        for (String order : orders) {
            customOrder.add(order.trim());
        }
        this.tagOrder = customOrder;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        int parentType = AtclauseOrderCheck.getParentType(this.getBlockCommentAst());
        if (this.target.contains(parentType)) {
            this.checkOrderInTagSection(ast);
        }
    }

    private void checkOrderInTagSection(DetailNode javadoc) {
        int maxIndexOfPreviousTag = 0;
        for (DetailNode node : javadoc.getChildren()) {
            String tagText;
            int indexOfCurrentTag;
            if (node.getType() != 10071 || (indexOfCurrentTag = this.tagOrder.indexOf(tagText = JavadocUtil.getFirstChild(node).getText())) == -1) continue;
            if (indexOfCurrentTag < maxIndexOfPreviousTag) {
                this.log(node.getLineNumber(), MSG_KEY, this.tagOrder.toString());
                continue;
            }
            maxIndexOfPreviousTag = indexOfCurrentTag;
        }
    }

    private static int getParentType(DetailAST commentBlock) {
        DetailAST parentNode = commentBlock.getParent();
        int result = parentNode.getType();
        if (result == 13 || result == 5) {
            result = parentNode.getParent().getType();
        } else if (parentNode.getParent() != null && parentNode.getParent().getType() == 5) {
            result = parentNode.getParent().getParent().getType();
        }
        return result;
    }
}

