/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.AuditListener;
import org.openrewrite.tools.checkstyle.api.AutomaticBean;
import org.openrewrite.tools.checkstyle.api.SeverityLevel;

public class SarifLogger
extends AutomaticBean
implements AuditListener {
    private static final int UNICODE_LENGTH = 4;
    private static final int UNICODE_ESCAPE_UPPER_LIMIT = 31;
    private static final int BUFFER_SIZE = 1024;
    private static final String MESSAGE_PLACEHOLDER = "${message}";
    private static final String SEVERITY_LEVEL_PLACEHOLDER = "${severityLevel}";
    private static final String URI_PLACEHOLDER = "${uri}";
    private static final String LINE_PLACEHOLDER = "${line}";
    private static final String COLUMN_PLACEHOLDER = "${column}";
    private static final String RULE_ID_PLACEHOLDER = "${ruleId}";
    private static final String VERSION_PLACEHOLDER = "${version}";
    private static final String RESULTS_PLACEHOLDER = "${results}";
    private final PrintWriter writer;
    private final boolean closeStream;
    private final List<String> results = new ArrayList<String>();
    private final String report;
    private final String resultLineColumn;
    private final String resultLineOnly;
    private final String resultFileOnly;
    private final String resultErrorOnly;

    public SarifLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) throws IOException {
        if (outputStreamOptions == null) {
            throw new IllegalArgumentException("Parameter outputStreamOptions can not be null");
        }
        this.writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.closeStream = outputStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
        this.report = SarifLogger.readResource("/org/openrewrite/tools/checkstyle/sarif/SarifReport.template");
        this.resultLineColumn = SarifLogger.readResource("/org/openrewrite/tools/checkstyle/sarif/ResultLineColumn.template");
        this.resultLineOnly = SarifLogger.readResource("/org/openrewrite/tools/checkstyle/sarif/ResultLineOnly.template");
        this.resultFileOnly = SarifLogger.readResource("/org/openrewrite/tools/checkstyle/sarif/ResultFileOnly.template");
        this.resultErrorOnly = SarifLogger.readResource("/org/openrewrite/tools/checkstyle/sarif/ResultErrorOnly.template");
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void auditStarted(AuditEvent event) {
    }

    @Override
    public void auditFinished(AuditEvent event) {
        String version = SarifLogger.class.getPackage().getImplementationVersion();
        String rendered = this.report.replace(VERSION_PLACEHOLDER, String.valueOf(version)).replace(RESULTS_PLACEHOLDER, String.join((CharSequence)",\n", this.results));
        this.writer.print(rendered);
        if (this.closeStream) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public void addError(AuditEvent event) {
        if (event.getColumn() > 0) {
            this.results.add(this.resultLineColumn.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, event.getFileName()).replace(COLUMN_PLACEHOLDER, Integer.toString(event.getColumn())).replace(LINE_PLACEHOLDER, Integer.toString(event.getLine())).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(event.getMessage())).replace(RULE_ID_PLACEHOLDER, event.getViolation().getKey()));
        } else {
            this.results.add(this.resultLineOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, event.getFileName()).replace(LINE_PLACEHOLDER, Integer.toString(event.getLine())).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(event.getMessage())).replace(RULE_ID_PLACEHOLDER, event.getViolation().getKey()));
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        throwable.printStackTrace(printer);
        if (event.getFileName() == null) {
            this.results.add(this.resultErrorOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(stringWriter.toString())));
        } else {
            this.results.add(this.resultFileOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, event.getFileName()).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(stringWriter.toString())));
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
    }

    private static String renderSeverityLevel(SeverityLevel severityLevel) {
        String renderedSeverityLevel;
        switch (severityLevel) {
            case IGNORE: {
                renderedSeverityLevel = "none";
                break;
            }
            case INFO: {
                renderedSeverityLevel = "note";
                break;
            }
            case WARNING: {
                renderedSeverityLevel = "warning";
                break;
            }
            default: {
                renderedSeverityLevel = "error";
            }
        }
        return renderedSeverityLevel;
    }

    public static String escape(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        block10: for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            switch (chr) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (chr <= '\u001f') {
                        sb.append(SarifLogger.escapeUnicode1F(chr));
                        continue block10;
                    }
                    sb.append(chr);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeUnicode1F(char chr) {
        StringBuilder stringBuilder = new StringBuilder(5);
        stringBuilder.append("\\u");
        String hexString = Integer.toHexString(chr);
        for (int i = 0; i < 4 - hexString.length(); ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(hexString.toUpperCase(Locale.US));
        return stringBuilder.toString();
    }

    /*
     * Exception decompiling
     */
    public static String readResource(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

