/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openAPI;
    private Map<String, Schema> addedModels = new HashMap<String, Schema>();
    private Map<String, String> generatedSignature = new HashMap<String, String>();
    private Map<String, String> inlineSchemaNameMapping = new HashMap<String, String>();
    private Map<String, String> inlineSchemaOptions = new HashMap<String, String>();
    private Set<String> inlineSchemaNameMappingValues = new HashSet<String>();
    public boolean resolveInlineEnums = false;
    public boolean skipSchemaReuse = false;
    public Boolean refactorAllOfInlineSchemas = null;
    private static ObjectMapper structureMapper = Json.mapper().copy();
    private Set<String> uniqueNames = new HashSet<String>();
    final Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);

    public InlineModelResolver() {
        this.inlineSchemaOptions.put("ARRAY_ITEM_SUFFIX", "_inner");
        this.inlineSchemaOptions.put("MAP_ITEM_SUFFIX", "_value");
    }

    public void setInlineSchemaNameMapping(Map inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping = inlineSchemaNameMapping;
        this.inlineSchemaNameMappingValues = new HashSet(inlineSchemaNameMapping.values());
    }

    public void setInlineSchemaOptions(Map inlineSchemaOptions) {
        this.inlineSchemaOptions.putAll(inlineSchemaOptions);
        if ("true".equalsIgnoreCase(this.inlineSchemaOptions.getOrDefault("SKIP_SCHEMA_REUSE", "false"))) {
            this.skipSchemaReuse = true;
        }
        if (this.inlineSchemaOptions.containsKey("REFACTOR_ALLOF_INLINE_SCHEMAS")) {
            this.refactorAllOfInlineSchemas = Boolean.valueOf(this.inlineSchemaOptions.get("REFACTOR_ALLOF_INLINE_SCHEMAS"));
        }
        if (this.inlineSchemaOptions.containsKey("RESOLVE_INLINE_ENUMS")) {
            this.resolveInlineEnums = Boolean.valueOf(this.inlineSchemaOptions.get("RESOLVE_INLINE_ENUMS"));
        }
    }

    void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new HashMap());
        }
        this.flattenPaths();
        this.flattenComponents();
    }

    private void flattenPaths() {
        Paths paths = this.openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            Operation operation;
            PathItem path = (PathItem)pathsEntry.getValue();
            ArrayList toFlatten = new ArrayList(path.readOperationsMap().entrySet());
            String pathname = (String)pathsEntry.getKey();
            for (Map.Entry operationEntry : new LinkedHashMap(path.readOperationsMap()).entrySet()) {
                operation = (Operation)operationEntry.getValue();
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                for (Map.Entry callbackEntry : callbacks.entrySet()) {
                    Callback callback = (Callback)callbackEntry.getValue();
                    for (Map.Entry pathItemEntry : callback.entrySet()) {
                        PathItem pathItem = (PathItem)pathItemEntry.getValue();
                        toFlatten.addAll(pathItem.readOperationsMap().entrySet());
                    }
                }
            }
            for (Map.Entry operationEntry : toFlatten) {
                operation = (Operation)operationEntry.getValue();
                String inlineSchemaName = this.getInlineSchemaName((PathItem.HttpMethod)operationEntry.getKey(), pathname);
                this.flattenRequestBody(inlineSchemaName, operation);
                this.flattenParameters(inlineSchemaName, operation);
                this.flattenResponses(inlineSchemaName, operation);
            }
        }
    }

    private String getInlineSchemaName(PathItem.HttpMethod httpVerb, String pathname) {
        Object name = pathname;
        if (httpVerb.equals((Object)PathItem.HttpMethod.DELETE)) {
            name = (String)name + "_delete";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.GET)) {
            name = (String)name + "_get";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.HEAD)) {
            name = (String)name + "_head";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.OPTIONS)) {
            name = (String)name + "_options";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.PATCH)) {
            name = (String)name + "_patch";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.POST)) {
            name = (String)name + "_post";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.PUT)) {
            name = (String)name + "_put";
        } else if (httpVerb.equals((Object)PathItem.HttpMethod.TRACE)) {
            name = (String)name + "_trace";
        }
        return name;
    }

    private boolean isModelNeeded(Schema schema) {
        return this.isModelNeeded(schema, new HashSet<Schema>());
    }

    private boolean isModelNeeded(Schema schema, Set<Schema> visitedSchemas) {
        if (visitedSchemas.contains(schema)) {
            return true;
        }
        visitedSchemas.add(schema);
        if (this.resolveInlineEnums && schema.getEnum() != null && schema.getEnum().size() > 0) {
            return true;
        }
        if ((schema.getType() == null || "object".equals(schema.getType())) && schema.getProperties() != null && schema.getProperties().size() > 0) {
            return true;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            boolean isNullable;
            boolean isSingleAllOf = schema.getAllOf() != null && schema.getAllOf().size() == 1;
            boolean isReadOnly = schema.getReadOnly() != null && schema.getReadOnly() != false;
            boolean bl = isNullable = schema.getNullable() != null && schema.getNullable() != false;
            if (isSingleAllOf && (isReadOnly || isNullable)) {
                ComposedSchema c = new ComposedSchema();
                c.setAllOf(schema.getAllOf());
                c.setReadOnly(schema.getReadOnly());
                c.setNullable(schema.getNullable());
                if (schema.equals((Object)c)) {
                    return this.isModelNeeded((Schema)schema.getAllOf().get(0), visitedSchemas);
                }
            } else if (isSingleAllOf && StringUtils.isNotEmpty((CharSequence)((Schema)schema.getAllOf().get(0)).get$ref())) {
                return this.isModelNeeded((Schema)schema.getAllOf().get(0), visitedSchemas);
            }
            if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
                for (Object inner : schema.getAllOf()) {
                    if (!this.isModelNeeded(ModelUtils.getReferencedSchema(this.openAPI, (Schema)inner), visitedSchemas)) continue;
                    return true;
                }
                return false;
            }
            if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
                return true;
            }
            if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private void gatherInlineModels(Schema schema, String modelPrefix) {
        Schema not;
        Schema refSchema;
        Object schemaName;
        Schema refSchema2;
        String schemaName2;
        if (schema.get$ref() != null) {
            if (this.isModelNeeded(schema) || "object".equals(schema.getType()) || schema.getProperties() != null || schema.getAdditionalProperties() != null || ModelUtils.isComposedSchema(schema)) {
                this.LOGGER.error("Illegal schema found with $ref combined with other properties, no properties should be defined alongside a $ref:\n " + schema.toString());
            }
            return;
        }
        if (schema.getType() == null || "object".equals(schema.getType())) {
            Schema inner;
            Map props = schema.getProperties();
            if (props != null) {
                for (String propName : props.keySet()) {
                    Schema prop = (Schema)props.get(propName);
                    if (prop == null) continue;
                    schemaName2 = this.resolveModelName(prop.getTitle(), modelPrefix + "_" + propName);
                    this.gatherInlineModels(prop, schemaName2);
                    if (this.isModelNeeded(prop)) {
                        refSchema2 = this.makeSchemaInComponents(schemaName2, prop);
                        props.put(propName, refSchema2);
                        continue;
                    }
                    if (!ModelUtils.isComposedSchema(prop) || prop.getAllOf() == null || prop.getAllOf().size() != 1 || ((Schema)prop.getAllOf().get(0)).getType() == null || "object".equals(((Schema)prop.getAllOf().get(0)).getType())) continue;
                    this.LOGGER.info("allOf schema used by the property `{}` replaced by its only item (a type)", (Object)propName);
                    props.put(propName, (Schema)prop.getAllOf().get(0));
                }
            }
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema && (inner = (Schema)schema.getAdditionalProperties()) != null) {
                schemaName = this.resolveModelName(schema.getTitle(), modelPrefix + this.inlineSchemaOptions.get("MAP_ITEM_SUFFIX"));
                this.gatherInlineModels(inner, (String)schemaName);
                if (this.isModelNeeded(inner)) {
                    refSchema = this.makeSchemaInComponents((String)schemaName, inner);
                    schema.setAdditionalProperties((Object)refSchema);
                }
            }
        } else {
            if (schema.getProperties() != null) {
                this.LOGGER.error("Illegal schema found with non-object type combined with properties, no properties should be defined:\n " + schema.toString());
                return;
            }
            if (schema.getAdditionalProperties() != null) {
                this.LOGGER.error("Illegal schema found with non-object type combined with additionalProperties, no additionalProperties should be defined:\n " + schema.toString());
                return;
            }
        }
        if (schema instanceof ArraySchema) {
            ArraySchema array = (ArraySchema)schema;
            Schema items = array.getItems();
            if (items == null) {
                this.LOGGER.error("Illegal schema found with array type but no items, items must be defined for array schemas:\n " + schema.toString());
                return;
            }
            schemaName = this.resolveModelName(items.getTitle(), modelPrefix + this.inlineSchemaOptions.get("ARRAY_ITEM_SUFFIX"));
            this.gatherInlineModels(items, (String)schemaName);
            if (this.isModelNeeded(items)) {
                refSchema = this.makeSchemaInComponents((String)schemaName, items);
                array.setItems(refSchema);
            }
        }
        if (ModelUtils.isComposedSchema(schema)) {
            Schema refSchema3;
            String schemaName3;
            if (schema.getAllOf() != null) {
                ArrayList<Schema> newAllOf = new ArrayList<Schema>();
                boolean atLeastOneModel = false;
                for (Object inner : schema.getAllOf()) {
                    if (inner == null) continue;
                    schemaName2 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_allOf");
                    this.gatherInlineModels((Schema)inner, schemaName2);
                    if (this.isModelNeeded((Schema)inner)) {
                        if (Boolean.TRUE.equals(this.refactorAllOfInlineSchemas)) {
                            refSchema2 = this.makeSchemaInComponents(schemaName2, (Schema)inner);
                            newAllOf.add(refSchema2);
                            atLeastOneModel = true;
                            continue;
                        }
                        newAllOf.add((Schema)inner);
                        atLeastOneModel = true;
                        continue;
                    }
                    newAllOf.add((Schema)inner);
                }
                if (atLeastOneModel) {
                    schema.setAllOf(newAllOf);
                } else if (schema.getAllOf().size() != 1) {
                    if (schema.getAllOf().size() > 1) {
                        this.LOGGER.warn("allOf schema `{}` containing multiple types (not model) is not supported at the moment.", (Object)schema.getName());
                    } else {
                        this.LOGGER.error("allOf schema `{}` contains no items.", (Object)schema.getName());
                    }
                }
            }
            if (schema.getAnyOf() != null) {
                ArrayList<Schema> newAnyOf = new ArrayList<Schema>();
                for (Object inner : schema.getAnyOf()) {
                    if (inner == null) continue;
                    schemaName3 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_anyOf");
                    this.gatherInlineModels((Schema)inner, schemaName3);
                    if (this.isModelNeeded((Schema)inner)) {
                        refSchema3 = this.makeSchemaInComponents(schemaName3, (Schema)inner);
                        newAnyOf.add(refSchema3);
                        continue;
                    }
                    newAnyOf.add((Schema)inner);
                }
                schema.setAnyOf(newAnyOf);
            }
            if (schema.getOneOf() != null) {
                ArrayList<Schema> newOneOf = new ArrayList<Schema>();
                for (Object inner : schema.getOneOf()) {
                    if (inner == null) continue;
                    schemaName3 = this.resolveModelName(((Schema)inner).getTitle(), modelPrefix + "_oneOf");
                    this.gatherInlineModels((Schema)inner, schemaName3);
                    if (this.isModelNeeded((Schema)inner)) {
                        refSchema3 = this.makeSchemaInComponents(schemaName3, (Schema)inner);
                        newOneOf.add(refSchema3);
                        continue;
                    }
                    newOneOf.add((Schema)inner);
                }
                schema.setOneOf(newOneOf);
            }
        }
        if (schema.getNot() != null && (not = schema.getNot()) != null) {
            String schemaName4 = this.resolveModelName(schema.getTitle(), modelPrefix + "_not");
            this.gatherInlineModels(not, schemaName4);
            if (this.isModelNeeded(not)) {
                Schema refSchema4 = this.makeSchemaInComponents(schemaName4, not);
                schema.setNot(refSchema4);
            }
        }
    }

    private void flattenContent(Content content, String name) {
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String contentType : content.keySet()) {
            Schema schema;
            MediaType mediaType = (MediaType)content.get((Object)contentType);
            if (mediaType == null || (schema = mediaType.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(schema.getTitle(), name);
            this.gatherInlineModels(schema, schemaName);
            if (!this.isModelNeeded(schema)) continue;
            Schema refSchema = this.makeSchemaInComponents(schemaName, schema);
            mediaType.setSchema(refSchema);
        }
    }

    private void flattenRequestBody(String modelName, Operation operation) {
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            return;
        }
        if (requestBody.get$ref() != null) {
            String ref = ModelUtils.getSimpleRef(requestBody.get$ref());
            requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(ref);
            if (requestBody == null) {
                return;
            }
        }
        this.flattenContent(requestBody.getContent(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_request");
    }

    private void flattenParameters(String modelName, Operation operation) {
        List parameters = operation.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            Schema parameterSchema;
            if (parameter.getSchema() == null || (parameterSchema = parameter.getSchema()) == null) continue;
            String schemaName = this.resolveModelName(parameterSchema.getTitle(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + parameter.getName() + "_parameter");
            this.gatherInlineModels(parameterSchema, schemaName);
            if (!this.isModelNeeded(parameterSchema)) continue;
            Schema refSchema = this.makeSchemaInComponents(schemaName, parameterSchema);
            parameter.setSchema(refSchema);
        }
    }

    private void flattenResponses(String modelName, Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        for (Map.Entry responsesEntry : responses.entrySet()) {
            String key = (String)responsesEntry.getKey();
            ApiResponse response = (ApiResponse)responsesEntry.getValue();
            this.flattenContent(response.getContent(), (operation.getOperationId() == null ? modelName : operation.getOperationId()) + "_" + key + "_response");
        }
    }

    private void flattenComposedChildren(String key, List<Schema> children, boolean skipAllOfInlineSchemas) {
        if (children == null || children.isEmpty()) {
            return;
        }
        ListIterator<Schema> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            Schema component = listIterator.next();
            if (component == null || component.get$ref() != null || (component.getProperties() == null || component.getProperties().isEmpty()) && (component.getEnum() == null || component.getEnum().isEmpty())) continue;
            String innerModelName = this.resolveModelName(component.getTitle(), key);
            Schema innerModel = this.modelFromProperty(this.openAPI, component, innerModelName);
            this.gatherInlineModels(innerModel, innerModelName);
            if (!skipAllOfInlineSchemas) {
                Schema schema;
                String existing = this.matchGenerated(innerModel);
                if (existing == null) {
                    innerModelName = this.addSchemas(innerModelName, innerModel);
                    schema = new Schema().$ref(innerModelName);
                    schema.setRequired(component.getRequired());
                    listIterator.set(schema);
                    continue;
                }
                schema = new Schema().$ref(existing);
                schema.setRequired(component.getRequired());
                listIterator.set(schema);
                continue;
            }
            this.LOGGER.debug("Inline allOf schema {} not refactored into a separate model using $ref.", (Object)innerModelName);
        }
    }

    private void flattenComponents() {
        Map models = this.openAPI.getComponents().getSchemas();
        if (models == null) {
            return;
        }
        ArrayList modelNames = new ArrayList(models.keySet());
        for (String modelName : modelNames) {
            Schema model = (Schema)models.get(modelName);
            if (model == null) continue;
            if (ModelUtils.isAnyOf(model)) {
                this.gatherInlineModels(model, modelName);
                continue;
            }
            if (ModelUtils.isOneOf(model)) {
                this.gatherInlineModels(model, modelName);
                continue;
            }
            if (ModelUtils.isComposedSchema(model)) {
                this.flattenComposedChildren(modelName + "_allOf", model.getAllOf(), !Boolean.TRUE.equals(this.refactorAllOfInlineSchemas));
                this.flattenComposedChildren(modelName + "_anyOf", model.getAnyOf(), false);
                this.flattenComposedChildren(modelName + "_oneOf", model.getOneOf(), false);
                continue;
            }
            this.gatherInlineModels(model, modelName);
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (this.schemaIsOfType(m, "string") && this.schemaContainsExample(m) && (example = m.getExample().toString()).startsWith("\"") && example.endsWith("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private boolean schemaIsOfType(Schema m, String type) {
        return m.getType() != null && m.getType().equals(type);
    }

    private boolean schemaContainsExample(Schema m) {
        return m.getExample() != null && m.getExample() != "";
    }

    private String resolveModelName(String title, String modelName) {
        if (title == null || "".equals(this.sanitizeName(title).replace("_", ""))) {
            if (modelName == null) {
                return this.uniqueName("inline_object");
            }
            return this.uniqueName(this.sanitizeName(modelName));
        }
        return this.uniqueName(this.sanitizeName(title));
    }

    private String matchGenerated(Schema model) {
        if (this.skipSchemaReuse) {
            return null;
        }
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            if (this.generatedSignature.containsKey(json)) {
                return this.generatedSignature.get(json);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addGenerated(String name, Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            this.generatedSignature.put(json, name);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private String sanitizeName(String name) {
        return name.replaceAll("^[0-9]", "_$0").replaceAll("[^A-Za-z0-9]", "_");
    }

    private String uniqueName(String name) {
        if (this.openAPI.getComponents().getSchemas() == null) {
            return name;
        }
        Object uniqueName = name;
        int count = 0;
        while (this.openAPI.getComponents().getSchemas().containsKey(uniqueName) || this.uniqueNames.contains(uniqueName)) {
            uniqueName = name + "_" + ++count;
        }
        return uniqueName;
    }

    private void flattenProperties(OpenAPI openAPI, Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> propertiesEntry : properties.entrySet()) {
            String key = propertiesEntry.getKey();
            Schema property = propertiesEntry.getValue();
            if (property instanceof ObjectSchema && ((ObjectSchema)property).getProperties() != null && ((ObjectSchema)property).getProperties().size() > 0) {
                Schema schema;
                ObjectSchema op = (ObjectSchema)property;
                String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(openAPI, (Schema)op, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    schema = new Schema().$ref(existing);
                    schema.setRequired(op.getRequired());
                    propsToUpdate.put(key, schema);
                    continue;
                }
                modelName = this.addSchemas(modelName, model);
                schema = new Schema().$ref(modelName);
                schema.setRequired(op.getRequired());
                propsToUpdate.put(key, schema);
                modelsToAdd.put(modelName, model);
                continue;
            }
            if (property instanceof ArraySchema) {
                ArraySchema ap = (ArraySchema)property;
                Schema inner = ap.getItems();
                if (inner instanceof ObjectSchema) {
                    Schema schema;
                    ObjectSchema op = (ObjectSchema)inner;
                    if (op.getProperties() == null || op.getProperties().size() <= 0) continue;
                    this.flattenProperties(openAPI, op.getProperties(), path);
                    String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
                    Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        schema = new Schema().$ref(existing);
                        schema.setRequired(op.getRequired());
                        ap.setItems(schema);
                        continue;
                    }
                    modelName = this.addSchemas(modelName, innerModel);
                    schema = new Schema().$ref(modelName);
                    schema.setRequired(op.getRequired());
                    ap.setItems(schema);
                    continue;
                }
                if (ModelUtils.isComposedSchema(inner)) {
                    String innerModelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
                    this.gatherInlineModels(inner, innerModelName);
                    innerModelName = this.addSchemas(innerModelName, inner);
                    Schema schema = new Schema().$ref(innerModelName);
                    schema.setRequired(inner.getRequired());
                    ap.setItems(schema);
                    continue;
                }
                this.LOGGER.debug("Schema not yet handled in model resolver: {}", (Object)inner);
                continue;
            }
            if (ModelUtils.isMapSchema(property)) {
                Schema inner = ModelUtils.getAdditionalProperties(property);
                if (inner instanceof ObjectSchema) {
                    Schema schema;
                    ObjectSchema op = (ObjectSchema)inner;
                    if (op.getProperties() == null || op.getProperties().size() <= 0) continue;
                    this.flattenProperties(openAPI, op.getProperties(), path);
                    String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
                    Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        schema = new Schema().$ref(existing);
                        schema.setRequired(op.getRequired());
                        property.setAdditionalProperties((Object)schema);
                        continue;
                    }
                    modelName = this.addSchemas(modelName, innerModel);
                    schema = new Schema().$ref(modelName);
                    schema.setRequired(op.getRequired());
                    property.setAdditionalProperties((Object)schema);
                    continue;
                }
                if (ModelUtils.isComposedSchema(inner)) {
                    String innerModelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
                    this.gatherInlineModels(inner, innerModelName);
                    innerModelName = this.addSchemas(innerModelName, inner);
                    Schema schema = new Schema().$ref(innerModelName);
                    schema.setRequired(inner.getRequired());
                    property.setAdditionalProperties((Object)schema);
                    continue;
                }
                this.LOGGER.debug("Schema not yet handled in model resolver: {}", (Object)inner);
                continue;
            }
            if (ModelUtils.isComposedSchema(property)) {
                if (!(property.getAllOf() == null || property.getAllOf().size() != 1 || property.getOneOf() != null && !property.getOneOf().isEmpty() || property.getAnyOf() != null && !property.getAnyOf().isEmpty() || property.getProperties() != null && !property.getProperties().isEmpty())) {
                    this.LOGGER.debug("allOf with a single item (which can be handled by default codegen) skipped by inline model resolver: {}", (Object)property);
                    continue;
                }
                String propertyModelName = this.resolveModelName(property.getTitle(), path + "_" + key);
                this.gatherInlineModels(property, propertyModelName);
                propertyModelName = this.addSchemas(propertyModelName, property);
                Schema schema = new Schema().$ref(propertyModelName);
                schema.setRequired(property.getRequired());
                propsToUpdate.put(key, schema);
                continue;
            }
            this.LOGGER.debug("Schema not yet handled in model resolver: {}", (Object)property);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    private Schema modelFromProperty(OpenAPI openAPI, Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        XML xml = object.getXml();
        Map properties = object.getProperties();
        Schema model = new Schema();
        model.setType(object.getType());
        model.setFormat(object.getFormat());
        if (object.getExample() != null) {
            model.setExample((Object)example);
        }
        model.setDescription(description);
        model.setName(object.getName());
        model.setXml(xml);
        model.setRequired(object.getRequired());
        model.setNullable(object.getNullable());
        model.setEnum(object.getEnum());
        model.setType(object.getType());
        model.setDiscriminator(object.getDiscriminator());
        model.setWriteOnly(object.getWriteOnly());
        model.setUniqueItems(object.getUniqueItems());
        model.setTitle(object.getTitle());
        model.setReadOnly(object.getReadOnly());
        model.setPattern(object.getPattern());
        model.setNot(object.getNot());
        model.setMinProperties(object.getMinProperties());
        model.setMinLength(object.getMinLength());
        model.setMinItems(object.getMinItems());
        model.setMinimum(object.getMinimum());
        model.setMaxProperties(object.getMaxProperties());
        model.setMaxLength(object.getMaxLength());
        model.setMaxItems(object.getMaxItems());
        model.setMaximum(object.getMaximum());
        model.setExternalDocs(object.getExternalDocs());
        model.setExtensions(object.getExtensions());
        model.setExclusiveMinimum(object.getExclusiveMinimum());
        model.setExclusiveMaximum(object.getExclusiveMaximum());
        model.setDeprecated(object.getDeprecated());
        if (properties != null) {
            this.flattenProperties(openAPI, properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    private Schema makeSchemaInComponents(String name, Schema schema) {
        Schema refSchema;
        String existing = this.matchGenerated(schema);
        if (existing != null) {
            refSchema = new Schema().$ref(existing);
        } else {
            if (this.resolveInlineEnums && schema.getEnum() != null && schema.getEnum().size() > 0) {
                this.LOGGER.warn("Model " + name + " promoted to its own schema due to resolveInlineEnums=true");
            }
            name = this.addSchemas(name, schema);
            refSchema = new Schema().$ref(name);
        }
        this.copyVendorExtensions(schema, refSchema);
        return refSchema;
    }

    private Schema makeSchema(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    private void copyVendorExtensions(Schema source, Schema target) {
        Map vendorExtensions = source.getExtensions();
        if (vendorExtensions == null) {
            return;
        }
        for (String extName : vendorExtensions.keySet()) {
            target.addExtension(extName, vendorExtensions.get(extName));
        }
    }

    private String addSchemas(String name, Schema schema) {
        if (this.inlineSchemaNameMapping.containsKey(name)) {
            name = this.inlineSchemaNameMapping.get(name);
        }
        this.addGenerated(name, schema);
        this.openAPI.getComponents().addSchemas(name, schema);
        if (!name.equals(schema.getTitle()) && !this.inlineSchemaNameMappingValues.contains(name)) {
            this.LOGGER.info("Inline schema created as {}. To have complete control of the model name, set the `title` field or use the modelNameMapping option (e.g. --model-name-mappings {}=NewModel,ModelA=NewModelA in CLI) or inlineSchemaNameMapping option (--inline-schema-name-mappings {}=NewModel,ModelA=NewModelA in CLI).", new Object[]{name, name, name});
        }
        this.uniqueNames.add(name);
        return name;
    }

    static {
        structureMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        structureMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

