/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.externalize;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.publication.CodeDecorator;
import org.nuiton.wikitty.publication.MimeTypePubHelper;
import org.nuiton.wikitty.publication.PropertiesExtended;
import org.nuiton.wikitty.publication.WikittyFileUtil;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.publication.externalize.CompileHelper;
import org.nuiton.wikitty.publication.externalize.JarUtil;
import org.nuiton.wikitty.publication.synchro.WikittyPublicationFileSystem;
import org.nuiton.wikitty.publication.synchro.WikittyPublicationSynchronize;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

public class WikittyPublicationExternalize {
    private static Log log = LogFactory.getLog(WikittyPublicationExternalize.class);
    public static String JAR_CLASSPATH_DIR = "jars";
    public static String TEMPORARY_FILE_NAME = "tempBeforeJar";
    public static String DEFAULT_JAR_NAME = "pub-externalized";
    public static String VERSION_SUFFIX = ".version";
    public static String MIME_SUFFIX = ".mime";
    public static String SOURCE_EXTENSION = ".java";
    public static String COMPILED_EXTENSION = ".class";

    private WikittyPublicationExternalize() {
    }

    public static void main(String[] args) throws ArgumentsParserException, IOException {
        ApplicationConfig appconfig = new ApplicationConfig();
        appconfig.parse(args);
        appconfig.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), WikittyPublicationFileSystem.class.getName());
        File currentFile = new File(".");
        currentFile = new File(currentFile.getAbsolutePath()).getParentFile();
        String Label = currentFile.getName();
        String urlFileSystem = currentFile.getParent() + WikittyPublicationSynchronize.LABEL_DELIM + Label;
        appconfig.setOption(WikittyConfigOption.WIKITTY_SERVER_URL.getKey(), urlFileSystem);
        WikittyPublicationExternalize.externalize(appconfig);
    }

    public static void externalize(ApplicationConfig conf) throws ArgumentsParserException, IOException {
        Criteria findAllCrit = Search.query().keyword("*").criteria();
        WikittyPublicationExternalize.externalize(conf, findAllCrit);
    }

    public static void externalize(ApplicationConfig conf, Criteria crit) throws ArgumentsParserException, IOException {
        File currentFile = new File(".");
        currentFile = new File(currentFile.getAbsolutePath()).getParentFile();
        WikittyPublicationExternalize.externalize(conf, crit, currentFile);
    }

    public static void externalize(ApplicationConfig conf, Criteria crit, File targetDir) throws ArgumentsParserException, IOException {
        String jarName = DEFAULT_JAR_NAME;
        WikittyPublicationExternalize.externalize(conf, crit, targetDir, jarName);
    }

    public static File externalize(ApplicationConfig conf, Criteria crit, File TargetDir, String jarName) throws ArgumentsParserException, IOException {
        MimeTypePubHelper mimeHelper = new MimeTypePubHelper();
        CodeDecorator decorator = new CodeDecorator();
        WikittyProxy proxy = new WikittyProxy(WikittyServiceFactory.buildWikittyService((ApplicationConfig)conf));
        PagedResult allWikittyOnFS = proxy.findAllByCriteria(crit);
        File tempDirectory = new File(TargetDir + File.separator + TEMPORARY_FILE_NAME);
        tempDirectory.mkdir();
        File filePropertiesId = new File(tempDirectory + File.separator + WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
        filePropertiesId.createNewFile();
        PropertiesExtended idProperties = new PropertiesExtended(filePropertiesId);
        File filePropertiesMeta = new File(tempDirectory + File.separator + WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
        filePropertiesMeta.createNewFile();
        PropertiesExtended metaProperties = new PropertiesExtended(filePropertiesMeta);
        List<File> classPathAdds = WikittyPublicationExternalize.extractJarFromServiceForCompil(proxy);
        for (Wikitty wikit : allWikittyOnFS) {
            File wikittyFile;
            Object content;
            String extension;
            String mimeType;
            String name;
            Set labeles;
            if (!wikit.hasExtension("WikittyLabel") || (labeles = WikittyLabelHelper.getLabels((Wikitty)wikit)).size() == 0) continue;
            String label = labeles.toArray()[0].toString();
            WikittyFileUtil.createFilesFromLabelPath(tempDirectory, label);
            String labelPath = WikittyFileUtil.labelToPath(label);
            labelPath = labelPath + File.separator;
            String id = wikit.getId();
            metaProperties.put(id + VERSION_SUFFIX, wikit.getVersion());
            if (wikit.hasExtension("WikittyPubText")) {
                name = WikittyPubTextHelper.getName(wikit);
                mimeType = WikittyPubTextHelper.getMimeType(wikit);
                extension = mimeHelper.getExtensionForMime(mimeType);
                content = WikittyPubTextHelper.getContent(wikit);
                wikittyFile = new File(tempDirectory.getAbsolutePath() + File.separator + labelPath + name + "." + extension);
                wikittyFile.createNewFile();
                FileUtil.writeString((File)wikittyFile, (String)content);
                File javaFile = new File(tempDirectory.getAbsolutePath() + File.separator + labelPath + name + SOURCE_EXTENSION);
                javaFile.createNewFile();
                String codeClass = decorator.getCode(wikit);
                FileUtil.writeString((File)javaFile, (String)codeClass);
                File classDirectory = new File(tempDirectory.getAbsolutePath() + File.separator + labelPath);
                PrintWriter writer = new PrintWriter(System.out);
                CompileHelper.compile(classPathAdds, tempDirectory, javaFile, classDirectory, writer);
                idProperties.put(id, labelPath + name);
                metaProperties.put(id + MIME_SUFFIX, mimeType);
            }
            if (!wikit.hasExtension("WikittyPubData")) continue;
            content = WikittyPubDataHelper.getContent(wikit);
            mimeType = WikittyPubDataHelper.getMimeType(wikit);
            extension = mimeHelper.getExtensionForMime(mimeType);
            name = WikittyPubDataHelper.getName(wikit);
            wikittyFile = new File(tempDirectory.getAbsolutePath() + File.separator + labelPath + name + "." + extension);
            wikittyFile.createNewFile();
            FileUtil.byteToFile((byte[])content, (File)wikittyFile);
            metaProperties.put(id + MIME_SUFFIX, mimeType);
            idProperties.put(id, labelPath + name);
        }
        metaProperties.store();
        idProperties.store();
        File jarFile = new File(TargetDir + File.separator + jarName + ".jar");
        JarUtil.compressFiles(jarFile, tempDirectory);
        FileUtil.deleteRecursively((File)tempDirectory);
        return jarFile;
    }

    protected static List<File> extractJarFromServiceForCompil(WikittyProxy prox) {
        LinkedList<File> result = new LinkedList<File>();
        if (!FileUtils.getTempDirectory().exists()) {
            FileUtils.getTempDirectory().mkdir();
        }
        Search wikittyPubDataJarCrit = Search.query().eq("WikittyPubData.mimeType", "application/jar");
        String jarRepoPath = FileUtils.getTempDirectory().getAbsolutePath() + File.separator + JAR_CLASSPATH_DIR + "_" + WikittyPublicationSynchronize.class.getSimpleName();
        File jarRepo = new File(jarRepoPath);
        if (!jarRepo.exists()) {
            jarRepo.mkdir();
        }
        result.add(jarRepo);
        PagedResult jardatas = prox.findAllByCriteria(wikittyPubDataJarCrit.criteria());
        for (Wikitty w : jardatas) {
            String name = WikittyPubDataHelper.getName(w);
            byte[] content = WikittyPubDataHelper.getContent(w);
            File tempJar = new File(jarRepo.getAbsolutePath() + File.separator + name + ".jar");
            try {
                FileUtils.writeByteArrayToFile((File)tempJar, (byte[])content);
                result.add(tempJar);
            }
            catch (IOException e) {
                log.error((Object)"Error while writing jars for compile classpath", (Throwable)e);
            }
        }
        return result;
    }

    static {
        FileUtil.ENCODING = "UTF-8";
    }
}

