/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;

public class WikittyFileUtil {
    public static String WIKITTY_FILE_META_PROPERTIES_FILE = "meta.properties";
    public static String WIKITTY_LABEL_SEPARATOR = ".";
    public static String WIKITTY_ID_PROPERTIES_FILE = "ids.properties";
    static final Log log = LogFactory.getLog(WikittyFileUtil.class);

    public static String labelToPath(String label) {
        String result = label;
        result = result.replace(WIKITTY_LABEL_SEPARATOR, File.separator);
        result = result.replace(File.separator + File.separator, File.separator + ".");
        log.info((Object)("Convert label to path: " + label + " path:" + result));
        return result;
    }

    public static boolean createFilesFromLabelPath(File homeFile, String label) throws IOException {
        label = WikittyFileUtil.labelToPath(label);
        log.info((Object)("Create directory from path:" + label));
        String[] pathElements = StringUtil.split((String)label, (String)File.separator);
        boolean result = false;
        if (homeFile.exists() && homeFile.isDirectory()) {
            String path = homeFile.getCanonicalPath();
            result = true;
            for (int i = 0; i < pathElements.length; ++i) {
                path = path + File.separator + pathElements[i];
                File temp = new File(path);
                FileUtil.createDirectoryIfNecessary((File)temp);
                result = result && temp.exists();
            }
        }
        return result;
    }
}

