/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.processor.Processor;
import org.nuiton.processor.filters.Filter;
import org.nuiton.processor.filters.GeneratorTemplatesFilter;
import org.nuiton.processor.filters.GeneratorTemplatesFilterIn;
import org.nuiton.util.Resource;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.publication.AbstractDecoredClass;
import org.nuiton.wikitty.publication.EvalInterface;
import org.nuiton.wikitty.publication.FilterOption;
import org.nuiton.wikitty.publication.MimeTypePubHelper;
import org.nuiton.wikitty.publication.PublicationContext;
import org.nuiton.wikitty.publication.entities.WikittyPubText;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.search.operators.Element;

public class CodeDecorator {
    protected static final String FILTERS_FILE_NAME_REGEX = "filters-\\w*\\.properties";
    private static Log log;
    protected static String MIME_SEP;
    protected static String filtersOptionDirName;
    protected static String filtersOptionDefault;
    protected Map<String, FilterOption> filtersOptions;
    protected static FilterOption defaultFilterOption;

    public CodeDecorator() {
        block3: {
            this.filtersOptions = new HashMap<String, FilterOption>();
            this.filtersOptions.put(defaultFilterOption.getKey(), defaultFilterOption);
            try {
                List urlsRessourceFilters = Resource.getResources((String)(filtersOptionDirName + FILTERS_FILE_NAME_REGEX), (ClassLoader)Thread.currentThread().getContextClassLoader());
                for (URL propFil : urlsRessourceFilters) {
                    Properties props = new Properties();
                    InputStream propsstrem = propFil.openStream();
                    props.load(propsstrem);
                    FilterOption option = new FilterOption();
                    option.setOpeningTemplate(props.getProperty(FilterOption.OPENING_TEMPLATE));
                    option.setWriteString(props.getProperty(FilterOption.WRITE_STRING));
                    option.setStringDelim(props.getProperty(FilterOption.STRING_DELIM));
                    option.setConcatChar(props.getProperty(FilterOption.CONCAT_CHAR));
                    option.setEndingCar(props.getProperty(FilterOption.ENDING_CAR));
                    option.setClosingWriterChar(props.getProperty(FilterOption.CLOSING_WRITER_CHAR));
                    option.setOpeningWriterChar(props.getProperty(FilterOption.OPENING_WRITER_CHAR));
                    option.setClosingTemplate(props.getProperty(FilterOption.CLOSING_TEMPLATE));
                    option.setKey(props.getProperty(FilterOption.KEY));
                    this.filtersOptions.put(option.getKey(), option);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error While reading filters option properties file", (Throwable)e);
            }
        }
    }

    public Wikitty transformPubUIToPubText(Wikitty wikitty) throws IOException {
        if (!wikitty.hasExtension("WikittyPubText")) {
            return wikitty;
        }
        GeneratorTemplatesFilter filter = new GeneratorTemplatesFilter();
        GeneratorTemplatesFilterIn filterIn = new GeneratorTemplatesFilterIn(filter);
        String mime = WikittyPubTextHelper.getMimeType(wikitty);
        String initialVersion = wikitty.getVersion();
        MimeTypePubHelper helper = new MimeTypePubHelper();
        String mimeAfterTransformation = helper.pubUiMimeToTargetMime(mime);
        String contentType = helper.uiMimeContentType(mime);
        String[] mimeTab = StringUtil.split((String)mime, (String)MIME_SEP);
        FilterOption foption = this.filtersOptions.get(mimeTab[1]);
        if (foption == null) {
            foption = defaultFilterOption;
        }
        filterIn.setConcacChar(foption.getConcatChar());
        filterIn.setStringDelim(foption.getStringDelim());
        filterIn.getParent().setWriteString(foption.getWriteString());
        filterIn.setEndCar(foption.getEndingCar());
        filterIn.setOpeningWriterChar(foption.getOpeningWriterChar());
        filterIn.setClosingWriterChar(foption.getClosingWriterChar());
        String decoringAffect = foption.getOpeningTemplate();
        String decoredContent = "";
        decoredContent = decoredContent + "wpContext.setContentType(\"" + contentType + "\")" + foption.getEndingCar();
        Processor proc = new Processor();
        proc.setInputFilter((Filter)filterIn);
        StringWriter writer = new StringWriter();
        String content = WikittyPubTextHelper.getContent(wikitty);
        StringReader reader = new StringReader(content);
        proc.process((Reader)reader, (Writer)writer);
        decoredContent = decoredContent + decoringAffect;
        decoredContent = decoredContent + writer.toString();
        decoredContent = decoredContent + foption.getClosingTemplate();
        WikittyPubTextHelper.setContent(wikitty, decoredContent);
        WikittyPubTextHelper.setMimeType(wikitty, mimeAfterTransformation);
        wikitty.setVersion(initialVersion);
        return wikitty;
    }

    public boolean isTransformationNeeded(Wikitty wikitty) {
        if (!wikitty.hasExtension("WikittyPubText")) {
            return false;
        }
        String mime = WikittyPubTextHelper.getMimeType(wikitty);
        return this.isMimeTypeUi(mime);
    }

    public boolean isTransformationNeeded(WikittyPubText wikitty) {
        String mime = wikitty.getMimeType();
        return this.isMimeTypeUi(mime);
    }

    public boolean isMimeTypeUi(String mime) {
        MimeTypePubHelper helper = new MimeTypePubHelper();
        String mimeKeyOption = helper.uiMimeToFilterOptionKey(mime);
        return this.filtersOptions.containsKey(mimeKeyOption);
    }

    public boolean isDecorated(String string) {
        return this.filtersOptions.containsKey(string);
    }

    public String getCode(Wikitty wikitty) {
        if (this.isTransformationNeeded(wikitty)) {
            try {
                wikitty = this.transformPubUIToPubText(wikitty);
            }
            catch (IOException e) {
                log.debug((Object)"Error while transform ui");
            }
        }
        String content = WikittyPubTextHelper.getContent(wikitty);
        String mimeType = WikittyPubTextHelper.getMimeType(wikitty);
        String className = WikittyPubTextHelper.getName(wikitty);
        String classContent = "";
        classContent = classContent + "import org.apache.commons.logging.Log;";
        classContent = classContent + "import org.apache.commons.logging.LogFactory;";
        classContent = classContent + "import org.nuiton.wikitty.ScriptEvaluator;";
        classContent = classContent + "import " + AbstractDecoredClass.class.getName() + ";";
        classContent = classContent + "import org.nuiton.wikitty.entities.*;";
        classContent = classContent + "import org.nuiton.wikitty.publication.entities.*;";
        classContent = classContent + "import org.nuiton.wikitty.publication.*;";
        classContent = classContent + "import java.util.*;";
        classContent = classContent + "public class " + className + " extends " + AbstractDecoredClass.class.getSimpleName() + " {";
        classContent = classContent + "public Object eval(Map<String, Object> bindings ) throws Exception {";
        if (mimeType.equals("text/java")) {
            classContent = classContent + PublicationContext.class.getSimpleName() + " " + "wpContext" + " = (" + PublicationContext.class.getSimpleName() + ") bindings.get(\"" + "wpContext" + "\");";
            classContent = classContent + EvalInterface.class.getSimpleName() + " " + "wpEval" + " = (" + EvalInterface.class.getSimpleName() + ") bindings.get(\"" + "wpEval" + "\");";
            classContent = classContent + "String wpPage = (String) bindings.get(\"wpPage\");";
            classContent = classContent + "List<String> wpSubContext = (List<String>) bindings.get(\"wpSubContext\");";
            classContent = classContent + "Wikitty wpWikitty = (Wikitty) bindings.get(\"wpWikitty\");";
            classContent = classContent + content;
        } else {
            classContent = classContent + "Object result = null;";
            classContent = classContent + "String content = \"" + StringEscapeUtils.escapeJava((String)content) + "\";";
            classContent = classContent + "String mimeType = \"" + StringEscapeUtils.escapeJava((String)mimeType) + "\";";
            classContent = classContent + "String criteriaName=  \"" + Element.ELT_ID + ":" + wikitty.getId() + "\";";
            classContent = classContent + " result = ScriptEvaluator.eval(null, criteriaName, content, mimeType, bindings);";
            classContent = classContent + "return result;";
        }
        classContent = classContent + "\n}\n}\n";
        return classContent;
    }

    public Map<String, FilterOption> getFiltersOptions() {
        return this.filtersOptions;
    }

    public void setFiltersOptions(Map<String, FilterOption> filtersOptions) {
        this.filtersOptions = filtersOptions;
    }

    static {
        Properties mimeProps;
        block2: {
            log = LogFactory.getLog(CodeDecorator.class);
            MIME_SEP = "/";
            filtersOptionDirName = "filters-properties/";
            filtersOptionDefault = "filters-default.properties";
            InputStream input = CodeDecorator.class.getResourceAsStream("/" + filtersOptionDirName + filtersOptionDefault);
            mimeProps = new Properties();
            try {
                mimeProps.load(input);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Error while reading properties Fie that containt filters option mapping ", (Throwable)e);
            }
        }
        defaultFilterOption = new FilterOption();
        defaultFilterOption.setOpeningTemplate(mimeProps.getProperty(FilterOption.OPENING_TEMPLATE));
        defaultFilterOption.setWriteString(mimeProps.getProperty(FilterOption.WRITE_STRING));
        defaultFilterOption.setStringDelim(mimeProps.getProperty(FilterOption.STRING_DELIM));
        defaultFilterOption.setConcatChar(mimeProps.getProperty(FilterOption.CONCAT_CHAR));
        defaultFilterOption.setEndingCar(mimeProps.getProperty(FilterOption.ENDING_CAR));
        defaultFilterOption.setClosingWriterChar(mimeProps.getProperty(FilterOption.CLOSING_WRITER_CHAR));
        defaultFilterOption.setOpeningWriterChar(mimeProps.getProperty(FilterOption.OPENING_WRITER_CHAR));
        defaultFilterOption.setClosingTemplate(mimeProps.getProperty(FilterOption.CLOSING_TEMPLATE));
        defaultFilterOption.setKey(mimeProps.getProperty(FilterOption.KEY));
    }
}

