/*
 * #%L
 * Wikitty :: dto
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;


public  class WikittyGroupDTO implements WikittyGroup {


@WikittyField(fqn="WikittyGroup.name")    protected String name;

@WikittyField(fqn="WikittyGroup.members")    protected Set<String> members = new LinkedHashSet<String>();
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        return name;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        this.name=name;
        modificationCount++;
}

    /**
     * getMembers :
     * @return Set<String> 
     */

    @Override
    public Set<String> getMembers() {
        return members;
}

    /**
     * setMembers :
     * @param members 
     */

    @Override
    public void setMembers(Set<String> members) {
        if (members == null){
            this.members = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.members=new LinkedHashSet<String>(members);
        }
        modificationCount++;
}

    /**
     * addAllMembers :
     * @param members 
     */

    @Override
    public void addAllMembers(Set<String> members) {
        if (this.members == null){
            this.members = new LinkedHashSet<String>();
        }
        this.members.addAll(members);
        modificationCount++;
}

    /**
     * addMembers :
     * @param element 
     */

    @Override
    public void addMembers(String element) {
        if (this.members == null){
            this.members = new LinkedHashSet<String>();
        }
        this.members.add(element);
        modificationCount++;
}

    /**
     * removeMembers :
     * @param element 
     */

    @Override
    public void removeMembers(String element) {
        members.remove(element);
        modificationCount++;
}

    /**
     * clearMembers :
     */

    @Override
    public void clearMembers() {
        members.clear();
        modificationCount++;
}

    /**
     * WikittyGroupDTO :
     */

    public WikittyGroupDTO() {
}

    /**
     * WikittyGroupDTO :
     * @param wikittyId 
     */

    public WikittyGroupDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyGroup)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyGroup sourceCopy = (WikittyGroup)source;

        setName(sourceCopy.getName());

        Set<String> members = sourceCopy.getMembers();
        if (members != null){
            setMembers(new LinkedHashSet<String>(members));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //WikittyGroupDTO
